#!/bin/sh

# panic: _pctrie_lookup_node: freed node in iter path
# cpuid = 0
# time = 1745029155
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe01085d2a30
# vpanic() at vpanic+0x136/frame 0xfffffe01085d2b60
# panic() at panic+0x43/frame 0xfffffe01085d2bc0
# pctrie_iter_lookup_ge() at pctrie_iter_lookup_ge+0x166/frame 0xfffffe01085d2bd0
# vm_object_page_clean() at vm_object_page_clean+0x22e/frame 0xfffffe01085d2c50
# vnode_pager_clean_async() at vnode_pager_clean_async+0x48/frame 0xfffffe01085d2c70
# vinactivef() at vinactivef+0x75/frame 0xfffffe01085d2cb0
# vput_final() at vput_final+0x29c/frame 0xfffffe01085d2d00
# vm_map_process_deferred() at vm_map_process_deferred+0xa9/frame 0xfffffe01085d2d20
# vm_map_remove() at vm_map_remove+0xcb/frame 0xfffffe01085d2d50
# vmspace_exit() at vmspace_exit+0xa8/frame 0xfffffe01085d2d80
# exit1() at exit1+0x533/frame 0xfffffe01085d2df0
# sys_exit() at sys_exit+0xd/frame 0xfffffe01085d2e00
# amd64_syscall() at amd64_syscall+0x15a/frame 0xfffffe01085d2f30
# fast_syscall_common() at fast_syscall_common+0xf8/frame 0xfffffe01085d2f30
# --- syscall (1, FreeBSD ELF64, exit), rip = 0x822a9b7fa, rsp = 0x8202b4de8, rbp = 0x8202b4e00 ---
# KDB: enter: panic
# [ thread pid 21141 tid 100328 ]
# Stopped at      kdb_enter+0x33: movq    $0,0x104d862(%rip)
# db> 

[ `id -u ` -ne 0 ] && echo "Must be root!" && exit 1

. ../default.cfg
set -u
prog=$(basename "$0" .sh)
cat > /tmp/$prog.c <<EOF
// https://syzkaller.appspot.com/bug?id=8658267170f7f61f4317bb04c1fe9add379ffaf4
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// syzbot+b5f9ebf4c2c63a5db681@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <sys/types.h>

#include <dirent.h>
#include <errno.h>
#include <pthread.h>
#include <pwd.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/resource.h>
#include <sys/stat.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void use_temporary_dir(void)
{
  char tmpdir_template[] = "./syzkaller.XXXXXX";
  char* tmpdir = mkdtemp(tmpdir_template);
  if (!tmpdir)
    exit(1);
  if (chmod(tmpdir, 0777))
    exit(1);
  if (chdir(tmpdir))
    exit(1);
}

static void reset_flags(const char* filename)
{
  struct stat st;
  if (lstat(filename, &st))
    exit(1);
  st.st_flags &= ~(SF_NOUNLINK | UF_NOUNLINK | SF_IMMUTABLE | UF_IMMUTABLE |
                   SF_APPEND | UF_APPEND);
  if (lchflags(filename, st.st_flags))
    exit(1);
}
static void __attribute__((noinline)) remove_dir(const char* dir)
{
  DIR* dp = opendir(dir);
  if (dp == NULL) {
    if (errno == EACCES) {
      if (rmdir(dir))
        exit(1);
      return;
    }
    exit(1);
  }
  struct dirent* ep = 0;
  while ((ep = readdir(dp))) {
    if (strcmp(ep->d_name, ".") == 0 || strcmp(ep->d_name, "..") == 0)
      continue;
    char filename[FILENAME_MAX];
    snprintf(filename, sizeof(filename), "%s/%s", dir, ep->d_name);
    struct stat st;
    if (lstat(filename, &st))
      exit(1);
    if (S_ISDIR(st.st_mode)) {
      remove_dir(filename);
      continue;
    }
    if (unlink(filename)) {
      if (errno == EPERM) {
        reset_flags(filename);
        reset_flags(dir);
        if (unlink(filename) == 0)
          continue;
      }
      exit(1);
    }
  }
  closedir(dp);
  while (rmdir(dir)) {
    if (errno == EPERM) {
      reset_flags(dir);
      if (rmdir(dir) == 0)
        break;
    }
    exit(1);
  }
}

static void thread_start(void* (*fn)(void*), void* arg)
{
  pthread_t th;
  pthread_attr_t attr;
  pthread_attr_init(&attr);
  pthread_attr_setstacksize(&attr, 128 << 10);
  int i = 0;
  for (; i < 100; i++) {
    if (pthread_create(&th, &attr, fn, arg) == 0) {
      pthread_attr_destroy(&attr);
      return;
    }
    if (errno == EAGAIN) {
      usleep(50);
      continue;
    }
    break;
  }
  exit(1);
}

typedef struct {
  pthread_mutex_t mu;
  pthread_cond_t cv;
  int state;
} event_t;

static void event_init(event_t* ev)
{
  if (pthread_mutex_init(&ev->mu, 0))
    exit(1);
  if (pthread_cond_init(&ev->cv, 0))
    exit(1);
  ev->state = 0;
}

static void event_reset(event_t* ev)
{
  ev->state = 0;
}

static void event_set(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  if (ev->state)
    exit(1);
  ev->state = 1;
  pthread_mutex_unlock(&ev->mu);
  pthread_cond_broadcast(&ev->cv);
}

static void event_wait(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  while (!ev->state)
    pthread_cond_wait(&ev->cv, &ev->mu);
  pthread_mutex_unlock(&ev->mu);
}

static int event_isset(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

static int event_timedwait(event_t* ev, uint64_t timeout)
{
  uint64_t start = current_time_ms();
  uint64_t now = start;
  pthread_mutex_lock(&ev->mu);
  for (;;) {
    if (ev->state)
      break;
    uint64_t remain = timeout - (now - start);
    struct timespec ts;
    ts.tv_sec = remain / 1000;
    ts.tv_nsec = (remain % 1000) * 1000 * 1000;
    pthread_cond_timedwait(&ev->cv, &ev->mu, &ts);
    now = current_time_ms();
    if (now - start > timeout)
      break;
  }
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

static void sandbox_common()
{
  struct rlimit rlim;
  rlim.rlim_cur = rlim.rlim_max = 128 << 20;
  setrlimit(RLIMIT_AS, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 8 << 20;
  setrlimit(RLIMIT_MEMLOCK, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 1 << 20;
  setrlimit(RLIMIT_FSIZE, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 1 << 20;
  setrlimit(RLIMIT_STACK, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 0;
  setrlimit(RLIMIT_CORE, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 256;
  setrlimit(RLIMIT_NOFILE, &rlim);
}

static void loop();

static int do_sandbox_none(void)
{
  sandbox_common();
  loop();
  return 0;
}

struct thread_t {
  int created, call;
  event_t ready, done;
};

static struct thread_t threads[16];
static void execute_call(int call);
static int running;

static void* thr(void* arg)
{
  struct thread_t* th = (struct thread_t*)arg;
  for (;;) {
    event_wait(&th->ready);
    event_reset(&th->ready);
    execute_call(th->call);
    __atomic_fetch_sub(&running, 1, __ATOMIC_RELAXED);
    event_set(&th->done);
  }
  return 0;
}

static void execute_one(void)
{
  if (write(1, "executing program\n", sizeof("executing program\n") - 1)) {
  }
  int i, call, thread;
  for (call = 0; call < 12; call++) {
    for (thread = 0; thread < (int)(sizeof(threads) / sizeof(threads[0]));
         thread++) {
      struct thread_t* th = &threads[thread];
      if (!th->created) {
        th->created = 1;
        event_init(&th->ready);
        event_init(&th->done);
        event_set(&th->done);
        thread_start(thr, th);
      }
      if (!event_isset(&th->done))
        continue;
      event_reset(&th->done);
      th->call = call;
      __atomic_fetch_add(&running, 1, __ATOMIC_RELAXED);
      event_set(&th->ready);
      event_timedwait(&th->done, 50);
      break;
    }
  }
  for (i = 0; i < 100 && __atomic_load_n(&running, __ATOMIC_RELAXED); i++)
    sleep_ms(1);
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  int iter = 0;
  for (;; iter++) {
    char cwdbuf[32];
    sprintf(cwdbuf, "./%d", iter);
    if (mkdir(cwdbuf, 0777))
      exit(1);
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      if (chdir(cwdbuf))
        exit(1);
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      sleep_ms(10);
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      if (current_time_ms() - start < 5000)
        continue;
      kill_and_wait(pid, &status);
      break;
    }
    remove_dir(cwdbuf);
  }
}

uint64_t r[5] = {0xffffffffffffffff, 0xffffffffffffffff, 0xffffffffffffffff,
                 0xffffffffffffffff, 0xffffffffffffffff};

void execute_call(int call)
{
  intptr_t res = 0;
  switch (call) {
  case 0:
    memcpy((void*)0x200000000000, "./file0\000", 8);
    res = syscall(SYS_openat, /*fd=*/0xffffff9c, /*file=*/0x200000000000ul,
                  /*flags=O_VERIFY|O_CREAT|O_WRONLY*/ 0x200201ul, /*mode=*/0ul);
    if (res != -1)
      r[0] = res;
    break;
  case 1:
    *(uint32_t*)0x200000000240 = r[0];
    *(uint64_t*)0x200000000248 = 0x80000001;
    *(uint64_t*)0x200000000250 = 0x2000000004c0;
    memcpy((void*)0x2000000004c0, "\x45\x09\xee\x8f\xcd", 5);
    *(uint64_t*)0x200000000258 = 5;
    *(uint32_t*)0x200000000260 = 3;
    *(uint32_t*)0x200000000264 = 0;
    *(uint64_t*)0x200000000268 = 0x200000000000000;
    *(uint32_t*)0x200000000270 = 8;
    *(uint32_t*)0x200000000274 = 0;
    *(uint64_t*)0x200000000278 = 1;
    *(uint64_t*)0x200000000280 = 7;
    *(uint64_t*)0x200000000288 = 0;
    *(uint32_t*)0x200000000290 = 0;
    *(uint32_t*)0x200000000294 = 0x20000005;
    *(uint32_t*)0x200000000298 = 0x2e5562f1;
    *(uint16_t*)0x2000000002a0 = 0xc088;
    syscall(SYS_aio_write, /*iocb=*/0x200000000240ul);
    break;
  case 2:
    memcpy((void*)0x200000000480, "./file0\000", 8);
    res = syscall(SYS_open, /*file=*/0x200000000480ul,
                  /*flags=O_VERIFY*/ 0x200000ul,
                  /*mode=S_IWOTH|S_IWGRP|S_IXUSR|S_IWUSR*/ 0xd2ul);
    if (res != -1)
      r[1] = res;
    break;
  case 3:
    syscall(SYS_mmap, /*addr=*/0x200000000000ul, /*len=*/0x200000ul,
            /*prot=PROT_WRITE|PROT_READ*/ 3ul,
            /*flags=MAP_FIXED|MAP_PRIVATE*/ 0x12ul, /*fd=*/r[1],
            /*offset=*/0ul);
    break;
  case 4:
    memcpy((void*)0x200000000100, "./file0\000", 8);
    res = syscall(SYS_open, /*file=*/0x200000000100ul,
                  /*flags=O_DIRECT*/ 0x10000ul, /*mode=*/0ul);
    if (res != -1)
      r[2] = res;
    break;
  case 5:
    memcpy((void*)0x2000000016c0, "./file0\000", 8);
    res = syscall(SYS_open, /*file=*/0x2000000016c0ul, /*flags=O_WRONLY*/ 1ul,
                  /*mode=*/0ul);
    if (res != -1)
      r[3] = res;
    break;
  case 6:
    *(uint64_t*)0x200000000080 = 0x2000000006c0;
    *(uint64_t*)0x200000000088 = 0x100000;
    syscall(SYS_pwritev, /*fd=*/r[3], /*vec=*/0x200000000080ul, /*vlen=*/1ul,
            /*off=*/0ul);
    break;
  case 7:
    *(uint64_t*)0x200000001780 = 0x200000000180;
    *(uint64_t*)0x200000001788 = 0x1b133353141e377d;
    syscall(SYS_preadv, /*fd=*/r[2], /*vec=*/0x200000001780ul,
            /*vlen=*/0x10000000000000d1ul, /*off=*/0ul);
    break;
  case 8:
    memcpy((void*)0x200000000480, "./file0\000", 8);
    res = syscall(
        SYS_open, /*file=*/0x200000000480ul,
        /*flags=O_NONBLOCK|O_CREAT|O_RDWR|0x80400000000000*/ 0x80400000000206ul,
        /*mode=*/0ul);
    if (res != -1)
      r[4] = res;
    break;
  case 9:
    syscall(SYS_mmap, /*addr=*/0x200000000000ul, /*len=*/0x200000ul,
            /*prot=PROT_WRITE|PROT_READ*/ 3ul,
            /*flags=MAP_FIXED|MAP_SHARED|0x20000*/ 0x20011ul, /*fd=*/r[4],
            /*offset=*/0ul);
    break;
  case 10:
    syscall(SYS_setsockopt, /*fd=*/(intptr_t)-1, /*level=*/6,
            /*optname=TCP_LOGID*/ 0x24, /*optval=*/0ul, /*optlen=*/0ul);
    break;
  case 11:
    syscall(SYS_setsockopt, /*fd=*/(intptr_t)-1, /*level=*/6,
            /*optname=TCP_LOGID*/ 0x24, /*optval=*/0ul, /*optlen=*/0ul);
    break;
  }
}
int main(void)
{
  syscall(SYS_mmap, /*addr=*/0x200000000000ul, /*len=*/0x1000000ul,
          /*prot=PROT_WRITE|PROT_READ|PROT_EXEC*/ 7ul,
          /*flags=MAP_FIXED|MAP_ANONYMOUS|MAP_PRIVATE*/ 0x1012ul,
          /*fd=*/(intptr_t)-1, /*offset=*/0ul);
  const char* reason;
  (void)reason;
  use_temporary_dir();
  do_sandbox_none();
  return 0;
}
EOF
mycc -o /tmp/$prog -Wall -Wextra -O0 /tmp/$prog.c -lpthread || exit 1

cd /tmp
timeout 3m /tmp/$prog > /dev/null 2>&1

rm -rf /tmp/$prog /tmp/$prog.c /tmp/$prog.core /tmp/$prog.??????
exit 0
