//
// Copyright (c) 2012 Red Hat, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//           http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// *********************************************************************
// ********************* GENERATED CODE - DO NOT MODIFY ****************
// *********************************************************************

package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;

import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.entities.Action;
import org.ovirt.engine.sdk.entities.Response;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.HttpHeaderUtils;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

/**
 * <p>StorageConnection providing relation and functional services
 * <p>to {@link org.ovirt.engine.sdk.entities.StorageConnection }.
 */
@SuppressWarnings("unused")
public class StorageConnection extends
        org.ovirt.engine.sdk.entities.StorageConnection {

    private HttpProxyBroker proxy;
    private final Object LOCK = new Object();



    /**
     * @param proxy HttpProxyBroker
     */
    public StorageConnection(HttpProxyBroker proxy) {
        this.proxy = proxy;
    }

    /**
     * @return HttpProxyBroker
     */
    private HttpProxyBroker getProxy() {
        return proxy;
    }



    /**
     * Updates StorageConnection object.
     *
     * @param storageconnection {@link org.ovirt.engine.sdk.entities.StorageConnection}
     *    <pre>
     *    Overload 1:
     *
     *      update the specified iSCSI
     *      storage connection in the
     *      system
     *
     *      [storage_connection.port]
     *      [storage_connection.username]
     *      [storage_connection.password]
     *      [storage_connection.iqn]
     *      [storage_connection.address]
     *
     *    Overload 2:
     *
     *      update the specified nfs
     *      storage connection in the
     *      system
     *
     *      [storage_connection.nfs_timeo]
     *      [storage_connection.nfs_version]
     *      [storage_connection.nfs_retrans]
     *      [storage_connection.address]
     *      [storage_connection.path]
     *
     *    Overload 3:
     *
     *      update the specified vfs
     *      storage connection in the
     *      system
     *
     *      [storage_connection.mount_options]
     *      [storage_connection.vfs_type]
     *      [storage_connection.address]
     *      [storage_connection.path]
     *
     *    Overload 4:
     *
     *      update the specified local
     *      storage connection in the
     *      system
     *
     *      [storage_connection.path]
     *    </pre>
     *
     * @return
     *     {@link StorageConnection }
     *
     * @throws ClientProtocolException
     *             Signals that HTTP/S protocol error has occurred.
     * @throws ServerException
     *             Signals that an oVirt api error has occurred.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred.
     */
    public StorageConnection update() throws ClientProtocolException,
            ServerException, IOException {
        String url = this.getHref();

        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();

        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();

        return getProxy().update(
                url,
                this,
                org.ovirt.engine.sdk.entities.StorageConnection.class,
                StorageConnection.class,
                headers);
    }
    /**
     * Updates StorageConnection object.
     *
     * @param storageconnection {@link org.ovirt.engine.sdk.entities.StorageConnection}
     *    <pre>
     *    Overload 1:
     *
     *      update the specified iSCSI
     *      storage connection in the
     *      system
     *
     *      [storage_connection.port]
     *      [storage_connection.username]
     *      [storage_connection.password]
     *      [storage_connection.iqn]
     *      [storage_connection.address]
     *
     *    Overload 2:
     *
     *      update the specified nfs
     *      storage connection in the
     *      system
     *
     *      [storage_connection.nfs_timeo]
     *      [storage_connection.nfs_version]
     *      [storage_connection.nfs_retrans]
     *      [storage_connection.address]
     *      [storage_connection.path]
     *
     *    Overload 3:
     *
     *      update the specified vfs
     *      storage connection in the
     *      system
     *
     *      [storage_connection.mount_options]
     *      [storage_connection.vfs_type]
     *      [storage_connection.address]
     *      [storage_connection.path]
     *
     *    Overload 4:
     *
     *      update the specified local
     *      storage connection in the
     *      system
     *
     *      [storage_connection.path]
     *    </pre>
     *
     * @param correlationId
     *    <pre>
     *    [any string]
     *    </pre>
     *
     * @return
     *     {@link StorageConnection }
     *
     * @throws ClientProtocolException
     *             Signals that HTTP/S protocol error has occurred.
     * @throws ServerException
     *             Signals that an oVirt api error has occurred.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred.
     */
    public StorageConnection update(String correlationId) throws ClientProtocolException,
            ServerException, IOException {
        String url = this.getHref();

        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();

        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();

        return getProxy().update(
                url,
                this,
                org.ovirt.engine.sdk.entities.StorageConnection.class,
                StorageConnection.class,
                headers);
    }
    /**
     * Deletes object.
     *
     * @return
     *     {@link Response }
     *
     * @throws ClientProtocolException
     *             Signals that HTTP/S protocol error has occurred.
     * @throws ServerException
     *             Signals that an oVirt api error has occurred.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred.
     */
    public Response delete() throws ClientProtocolException,
            ServerException, IOException {
        String url = this.getHref();

        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();

        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();

        return getProxy().delete(url, Response.class, headers);
    }
    /**
     * Deletes object.
     *
     * @param correlationId
     *    <pre>
     *    [any string]
     *    </pre>
     * @param async
     *    <pre>
     *    [true|false]
     *    </pre>
     *
     * @return
     *     {@link Response }
     *
     * @throws ClientProtocolException
     *             Signals that HTTP/S protocol error has occurred.
     * @throws ServerException
     *             Signals that an oVirt api error has occurred.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred.
     */
    public Response delete(Boolean async, String correlationId) throws ClientProtocolException,
            ServerException, IOException {
        String url = this.getHref();

        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();

        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();

        return getProxy().delete(url, Response.class, headers);
    }
    /**
     * Deletes object.
     *
     * @param host {@link org.ovirt.engine.sdk.entities.Host}
     *    <pre>
     *    [host.id|name]
     *    </pre>
     *
     * @param correlationId
     *    <pre>
     *    [any string]
     *    </pre>
     * @param async
     *    <pre>
     *    [true|false]
     *    </pre>
     *
     * @return
     *     {@link Response }
     *
     * @throws ClientProtocolException
     *             Signals that HTTP/S protocol error has occurred.
     * @throws ServerException
     *             Signals that an oVirt api error has occurred.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred.
     */
    public Response delete(org.ovirt.engine.sdk.entities.Host host, Boolean async, String correlationId) throws ClientProtocolException,
            ServerException, IOException {
        String url = this.getHref();

        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();

        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();

        return getProxy().delete(url, host,
                org.ovirt.engine.sdk.entities.Host.class, Response.class, headers);
    }

}

