/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.String;
import org.ovirt.engine.sdk4.types.Certificate;

public class CertificateContainer extends IdentifiedContainer implements Certificate {
    private String content;
    private String organization;
    private String subject;
    
    public String content() {
        return content;
    }
    
    public void content(String newContent) {
        content = newContent;
    }
    
    public boolean contentPresent() {
        return content != null;
    }
    
    public String organization() {
        return organization;
    }
    
    public void organization(String newOrganization) {
        organization = newOrganization;
    }
    
    public boolean organizationPresent() {
        return organization != null;
    }
    
    public String subject() {
        return subject;
    }
    
    public void subject(String newSubject) {
        subject = newSubject;
    }
    
    public boolean subjectPresent() {
        return subject != null;
    }
    
}
