/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import org.ovirt.engine.sdk4.builders.CertificateBuilder;
import org.ovirt.engine.sdk4.internal.containers.DisplayContainer;
import org.ovirt.engine.sdk4.types.Certificate;
import org.ovirt.engine.sdk4.types.Display;
import org.ovirt.engine.sdk4.types.DisplayType;

public class DisplayBuilder {
    private String address;
    private Boolean allowOverride;
    private Certificate certificate;
    private Boolean copyPasteEnabled;
    private String disconnectAction;
    private Boolean fileTransferEnabled;
    private String keyboardLayout;
    private BigInteger monitors;
    private BigInteger port;
    private String proxy;
    private BigInteger securePort;
    private Boolean singleQxlPci;
    private Boolean smartcardEnabled;
    private DisplayType type;

    public DisplayBuilder address(String newAddress) {
        this.address = newAddress;
        return this;
    }

    public DisplayBuilder allowOverride(boolean newAllowOverride) {
        this.allowOverride = newAllowOverride;
        return this;
    }

    public DisplayBuilder allowOverride(Boolean newAllowOverride) {
        this.allowOverride = newAllowOverride;
        return this;
    }

    public DisplayBuilder certificate(Certificate newCertificate) {
        this.certificate = newCertificate;
        return this;
    }

    public DisplayBuilder certificate(CertificateBuilder newCertificate) {
        this.certificate = newCertificate == null ? null : newCertificate.build();
        return this;
    }

    public DisplayBuilder copyPasteEnabled(boolean newCopyPasteEnabled) {
        this.copyPasteEnabled = newCopyPasteEnabled;
        return this;
    }

    public DisplayBuilder copyPasteEnabled(Boolean newCopyPasteEnabled) {
        this.copyPasteEnabled = newCopyPasteEnabled;
        return this;
    }

    public DisplayBuilder disconnectAction(String newDisconnectAction) {
        this.disconnectAction = newDisconnectAction;
        return this;
    }

    public DisplayBuilder fileTransferEnabled(boolean newFileTransferEnabled) {
        this.fileTransferEnabled = newFileTransferEnabled;
        return this;
    }

    public DisplayBuilder fileTransferEnabled(Boolean newFileTransferEnabled) {
        this.fileTransferEnabled = newFileTransferEnabled;
        return this;
    }

    public DisplayBuilder keyboardLayout(String newKeyboardLayout) {
        this.keyboardLayout = newKeyboardLayout;
        return this;
    }

    public DisplayBuilder monitors(int newMonitors) {
        this.monitors = BigInteger.valueOf(newMonitors);
        return this;
    }

    public DisplayBuilder monitors(Integer newMonitors) {
        this.monitors = newMonitors == null ? null : BigInteger.valueOf(newMonitors.longValue());
        return this;
    }

    public DisplayBuilder monitors(long newMonitors) {
        this.monitors = BigInteger.valueOf(newMonitors);
        return this;
    }

    public DisplayBuilder monitors(Long newMonitors) {
        this.monitors = newMonitors == null ? null : BigInteger.valueOf(newMonitors);
        return this;
    }

    public DisplayBuilder monitors(BigInteger newMonitors) {
        this.monitors = newMonitors;
        return this;
    }

    public DisplayBuilder port(int newPort) {
        this.port = BigInteger.valueOf(newPort);
        return this;
    }

    public DisplayBuilder port(Integer newPort) {
        this.port = newPort == null ? null : BigInteger.valueOf(newPort.longValue());
        return this;
    }

    public DisplayBuilder port(long newPort) {
        this.port = BigInteger.valueOf(newPort);
        return this;
    }

    public DisplayBuilder port(Long newPort) {
        this.port = newPort == null ? null : BigInteger.valueOf(newPort);
        return this;
    }

    public DisplayBuilder port(BigInteger newPort) {
        this.port = newPort;
        return this;
    }

    public DisplayBuilder proxy(String newProxy) {
        this.proxy = newProxy;
        return this;
    }

    public DisplayBuilder securePort(int newSecurePort) {
        this.securePort = BigInteger.valueOf(newSecurePort);
        return this;
    }

    public DisplayBuilder securePort(Integer newSecurePort) {
        this.securePort = newSecurePort == null ? null : BigInteger.valueOf(newSecurePort.longValue());
        return this;
    }

    public DisplayBuilder securePort(long newSecurePort) {
        this.securePort = BigInteger.valueOf(newSecurePort);
        return this;
    }

    public DisplayBuilder securePort(Long newSecurePort) {
        this.securePort = newSecurePort == null ? null : BigInteger.valueOf(newSecurePort);
        return this;
    }

    public DisplayBuilder securePort(BigInteger newSecurePort) {
        this.securePort = newSecurePort;
        return this;
    }

    public DisplayBuilder singleQxlPci(boolean newSingleQxlPci) {
        this.singleQxlPci = newSingleQxlPci;
        return this;
    }

    public DisplayBuilder singleQxlPci(Boolean newSingleQxlPci) {
        this.singleQxlPci = newSingleQxlPci;
        return this;
    }

    public DisplayBuilder smartcardEnabled(boolean newSmartcardEnabled) {
        this.smartcardEnabled = newSmartcardEnabled;
        return this;
    }

    public DisplayBuilder smartcardEnabled(Boolean newSmartcardEnabled) {
        this.smartcardEnabled = newSmartcardEnabled;
        return this;
    }

    public DisplayBuilder type(DisplayType newType) {
        this.type = newType;
        return this;
    }

    public Display build() {
        DisplayContainer container = new DisplayContainer();
        container.address(this.address);
        container.allowOverride(this.allowOverride);
        container.certificate(this.certificate);
        container.copyPasteEnabled(this.copyPasteEnabled);
        container.disconnectAction(this.disconnectAction);
        container.fileTransferEnabled(this.fileTransferEnabled);
        container.keyboardLayout(this.keyboardLayout);
        container.monitors(this.monitors);
        container.port(this.port);
        container.proxy(this.proxy);
        container.securePort(this.securePort);
        container.singleQxlPci(this.singleQxlPci);
        container.smartcardEnabled(this.smartcardEnabled);
        container.type(this.type);
        return container;
    }
}

