/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.GroupBuilder;
import org.ovirt.engine.sdk4.builders.UserBuilder;
import org.ovirt.engine.sdk4.internal.containers.DomainContainer;
import org.ovirt.engine.sdk4.types.Domain;
import org.ovirt.engine.sdk4.types.Group;
import org.ovirt.engine.sdk4.types.User;

public class DomainBuilder {
    private String comment;
    private String description;
    private List<Group> groups;
    private String href;
    private String id;
    private String name;
    private User user;
    private List<User> users;

    public DomainBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public DomainBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public DomainBuilder groups(List<Group> newGroups) {
        if (newGroups != null) {
            if (this.groups == null) {
                this.groups = new ArrayList<Group>(newGroups);
            } else {
                this.groups.addAll(newGroups);
            }
        }
        return this;
    }

    public DomainBuilder groups(Group ... newGroups) {
        if (newGroups != null) {
            if (this.groups == null) {
                this.groups = new ArrayList<Group>(newGroups.length);
            }
            Collections.addAll(this.groups, newGroups);
        }
        return this;
    }

    public DomainBuilder groups(GroupBuilder ... newGroups) {
        if (newGroups != null) {
            if (this.groups == null) {
                this.groups = new ArrayList<Group>(newGroups.length);
            }
            for (GroupBuilder builder : newGroups) {
                this.groups.add(builder.build());
            }
        }
        return this;
    }

    public DomainBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public DomainBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public DomainBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public DomainBuilder user(User newUser) {
        this.user = newUser;
        return this;
    }

    public DomainBuilder user(UserBuilder newUser) {
        this.user = newUser == null ? null : newUser.build();
        return this;
    }

    public DomainBuilder users(List<User> newUsers) {
        if (newUsers != null) {
            if (this.users == null) {
                this.users = new ArrayList<User>(newUsers);
            } else {
                this.users.addAll(newUsers);
            }
        }
        return this;
    }

    public DomainBuilder users(User ... newUsers) {
        if (newUsers != null) {
            if (this.users == null) {
                this.users = new ArrayList<User>(newUsers.length);
            }
            Collections.addAll(this.users, newUsers);
        }
        return this;
    }

    public DomainBuilder users(UserBuilder ... newUsers) {
        if (newUsers != null) {
            if (this.users == null) {
                this.users = new ArrayList<User>(newUsers.length);
            }
            for (UserBuilder builder : newUsers) {
                this.users.add(builder.build());
            }
        }
        return this;
    }

    public Domain build() {
        DomainContainer container = new DomainContainer();
        container.comment(this.comment);
        container.description(this.description);
        container.groups(this.groups);
        container.href(this.href);
        container.id(this.id);
        container.name(this.name);
        container.user(this.user);
        container.users(this.users);
        return container;
    }
}

