/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.GlusterClientBuilder;
import org.ovirt.engine.sdk4.builders.GlusterMemoryPoolBuilder;
import org.ovirt.engine.sdk4.builders.GlusterVolumeBuilder;
import org.ovirt.engine.sdk4.builders.InstanceTypeBuilder;
import org.ovirt.engine.sdk4.builders.StatisticBuilder;
import org.ovirt.engine.sdk4.builders.TemplateBuilder;
import org.ovirt.engine.sdk4.builders.VmBuilder;
import org.ovirt.engine.sdk4.internal.containers.GlusterBrickContainer;
import org.ovirt.engine.sdk4.types.GlusterBrick;
import org.ovirt.engine.sdk4.types.GlusterBrickStatus;
import org.ovirt.engine.sdk4.types.GlusterClient;
import org.ovirt.engine.sdk4.types.GlusterMemoryPool;
import org.ovirt.engine.sdk4.types.GlusterVolume;
import org.ovirt.engine.sdk4.types.InstanceType;
import org.ovirt.engine.sdk4.types.Statistic;
import org.ovirt.engine.sdk4.types.Template;
import org.ovirt.engine.sdk4.types.Vm;

public class GlusterBrickBuilder {
    private String brickDir;
    private String comment;
    private String description;
    private String device;
    private String fsName;
    private List<GlusterClient> glusterClients;
    private GlusterVolume glusterVolume;
    private String href;
    private String id;
    private InstanceType instanceType;
    private List<GlusterMemoryPool> memoryPools;
    private String mntOptions;
    private String name;
    private BigInteger pid;
    private BigInteger port;
    private String serverId;
    private List<Statistic> statistics;
    private GlusterBrickStatus status;
    private Template template;
    private Vm vm;
    private List<Vm> vms;

    public GlusterBrickBuilder brickDir(String newBrickDir) {
        this.brickDir = newBrickDir;
        return this;
    }

    public GlusterBrickBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public GlusterBrickBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public GlusterBrickBuilder device(String newDevice) {
        this.device = newDevice;
        return this;
    }

    public GlusterBrickBuilder fsName(String newFsName) {
        this.fsName = newFsName;
        return this;
    }

    public GlusterBrickBuilder glusterClients(List<GlusterClient> newGlusterClients) {
        if (newGlusterClients != null) {
            if (this.glusterClients == null) {
                this.glusterClients = new ArrayList<GlusterClient>(newGlusterClients);
            } else {
                this.glusterClients.addAll(newGlusterClients);
            }
        }
        return this;
    }

    public GlusterBrickBuilder glusterClients(GlusterClient ... newGlusterClients) {
        if (newGlusterClients != null) {
            if (this.glusterClients == null) {
                this.glusterClients = new ArrayList<GlusterClient>(newGlusterClients.length);
            }
            Collections.addAll(this.glusterClients, newGlusterClients);
        }
        return this;
    }

    public GlusterBrickBuilder glusterClients(GlusterClientBuilder ... newGlusterClients) {
        if (newGlusterClients != null) {
            if (this.glusterClients == null) {
                this.glusterClients = new ArrayList<GlusterClient>(newGlusterClients.length);
            }
            for (GlusterClientBuilder builder : newGlusterClients) {
                this.glusterClients.add(builder.build());
            }
        }
        return this;
    }

    public GlusterBrickBuilder glusterVolume(GlusterVolume newGlusterVolume) {
        this.glusterVolume = newGlusterVolume;
        return this;
    }

    public GlusterBrickBuilder glusterVolume(GlusterVolumeBuilder newGlusterVolume) {
        this.glusterVolume = newGlusterVolume == null ? null : newGlusterVolume.build();
        return this;
    }

    public GlusterBrickBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public GlusterBrickBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public GlusterBrickBuilder instanceType(InstanceType newInstanceType) {
        this.instanceType = newInstanceType;
        return this;
    }

    public GlusterBrickBuilder instanceType(InstanceTypeBuilder newInstanceType) {
        this.instanceType = newInstanceType == null ? null : newInstanceType.build();
        return this;
    }

    public GlusterBrickBuilder memoryPools(List<GlusterMemoryPool> newMemoryPools) {
        if (newMemoryPools != null) {
            if (this.memoryPools == null) {
                this.memoryPools = new ArrayList<GlusterMemoryPool>(newMemoryPools);
            } else {
                this.memoryPools.addAll(newMemoryPools);
            }
        }
        return this;
    }

    public GlusterBrickBuilder memoryPools(GlusterMemoryPool ... newMemoryPools) {
        if (newMemoryPools != null) {
            if (this.memoryPools == null) {
                this.memoryPools = new ArrayList<GlusterMemoryPool>(newMemoryPools.length);
            }
            Collections.addAll(this.memoryPools, newMemoryPools);
        }
        return this;
    }

    public GlusterBrickBuilder memoryPools(GlusterMemoryPoolBuilder ... newMemoryPools) {
        if (newMemoryPools != null) {
            if (this.memoryPools == null) {
                this.memoryPools = new ArrayList<GlusterMemoryPool>(newMemoryPools.length);
            }
            for (GlusterMemoryPoolBuilder builder : newMemoryPools) {
                this.memoryPools.add(builder.build());
            }
        }
        return this;
    }

    public GlusterBrickBuilder mntOptions(String newMntOptions) {
        this.mntOptions = newMntOptions;
        return this;
    }

    public GlusterBrickBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public GlusterBrickBuilder pid(int newPid) {
        this.pid = BigInteger.valueOf(newPid);
        return this;
    }

    public GlusterBrickBuilder pid(Integer newPid) {
        this.pid = newPid == null ? null : BigInteger.valueOf(newPid.longValue());
        return this;
    }

    public GlusterBrickBuilder pid(long newPid) {
        this.pid = BigInteger.valueOf(newPid);
        return this;
    }

    public GlusterBrickBuilder pid(Long newPid) {
        this.pid = newPid == null ? null : BigInteger.valueOf(newPid);
        return this;
    }

    public GlusterBrickBuilder pid(BigInteger newPid) {
        this.pid = newPid;
        return this;
    }

    public GlusterBrickBuilder port(int newPort) {
        this.port = BigInteger.valueOf(newPort);
        return this;
    }

    public GlusterBrickBuilder port(Integer newPort) {
        this.port = newPort == null ? null : BigInteger.valueOf(newPort.longValue());
        return this;
    }

    public GlusterBrickBuilder port(long newPort) {
        this.port = BigInteger.valueOf(newPort);
        return this;
    }

    public GlusterBrickBuilder port(Long newPort) {
        this.port = newPort == null ? null : BigInteger.valueOf(newPort);
        return this;
    }

    public GlusterBrickBuilder port(BigInteger newPort) {
        this.port = newPort;
        return this;
    }

    public GlusterBrickBuilder serverId(String newServerId) {
        this.serverId = newServerId;
        return this;
    }

    public GlusterBrickBuilder statistics(List<Statistic> newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics);
            } else {
                this.statistics.addAll(newStatistics);
            }
        }
        return this;
    }

    public GlusterBrickBuilder statistics(Statistic ... newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics.length);
            }
            Collections.addAll(this.statistics, newStatistics);
        }
        return this;
    }

    public GlusterBrickBuilder statistics(StatisticBuilder ... newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics.length);
            }
            for (StatisticBuilder builder : newStatistics) {
                this.statistics.add(builder.build());
            }
        }
        return this;
    }

    public GlusterBrickBuilder status(GlusterBrickStatus newStatus) {
        this.status = newStatus;
        return this;
    }

    public GlusterBrickBuilder template(Template newTemplate) {
        this.template = newTemplate;
        return this;
    }

    public GlusterBrickBuilder template(TemplateBuilder newTemplate) {
        this.template = newTemplate == null ? null : newTemplate.build();
        return this;
    }

    public GlusterBrickBuilder vm(Vm newVm) {
        this.vm = newVm;
        return this;
    }

    public GlusterBrickBuilder vm(VmBuilder newVm) {
        this.vm = newVm == null ? null : newVm.build();
        return this;
    }

    public GlusterBrickBuilder vms(List<Vm> newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms);
            } else {
                this.vms.addAll(newVms);
            }
        }
        return this;
    }

    public GlusterBrickBuilder vms(Vm ... newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms.length);
            }
            Collections.addAll(this.vms, newVms);
        }
        return this;
    }

    public GlusterBrickBuilder vms(VmBuilder ... newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms.length);
            }
            for (VmBuilder builder : newVms) {
                this.vms.add(builder.build());
            }
        }
        return this;
    }

    public GlusterBrick build() {
        GlusterBrickContainer container = new GlusterBrickContainer();
        container.brickDir(this.brickDir);
        container.comment(this.comment);
        container.description(this.description);
        container.device(this.device);
        container.fsName(this.fsName);
        container.glusterClients(this.glusterClients);
        container.glusterVolume(this.glusterVolume);
        container.href(this.href);
        container.id(this.id);
        container.instanceType(this.instanceType);
        container.memoryPools(this.memoryPools);
        container.mntOptions(this.mntOptions);
        container.name(this.name);
        container.pid(this.pid);
        container.port(this.port);
        container.serverId(this.serverId);
        container.statistics(this.statistics);
        container.status(this.status);
        container.template(this.template);
        container.vm(this.vm);
        container.vms(this.vms);
        return container;
    }
}

