/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.ClusterBuilder;
import org.ovirt.engine.sdk4.builders.GlusterServerHookBuilder;
import org.ovirt.engine.sdk4.internal.containers.GlusterHookContainer;
import org.ovirt.engine.sdk4.types.Cluster;
import org.ovirt.engine.sdk4.types.GlusterHook;
import org.ovirt.engine.sdk4.types.GlusterHookStatus;
import org.ovirt.engine.sdk4.types.GlusterServerHook;
import org.ovirt.engine.sdk4.types.HookContentType;
import org.ovirt.engine.sdk4.types.HookStage;

public class GlusterHookBuilder {
    private String checksum;
    private Cluster cluster;
    private String comment;
    private BigInteger conflictStatus;
    private String conflicts;
    private String content;
    private HookContentType contentType;
    private String description;
    private String glusterCommand;
    private String href;
    private String id;
    private String name;
    private List<GlusterServerHook> serverHooks;
    private HookStage stage;
    private GlusterHookStatus status;

    public GlusterHookBuilder checksum(String newChecksum) {
        this.checksum = newChecksum;
        return this;
    }

    public GlusterHookBuilder cluster(Cluster newCluster) {
        this.cluster = newCluster;
        return this;
    }

    public GlusterHookBuilder cluster(ClusterBuilder newCluster) {
        this.cluster = newCluster == null ? null : newCluster.build();
        return this;
    }

    public GlusterHookBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public GlusterHookBuilder conflictStatus(int newConflictStatus) {
        this.conflictStatus = BigInteger.valueOf(newConflictStatus);
        return this;
    }

    public GlusterHookBuilder conflictStatus(Integer newConflictStatus) {
        this.conflictStatus = newConflictStatus == null ? null : BigInteger.valueOf(newConflictStatus.longValue());
        return this;
    }

    public GlusterHookBuilder conflictStatus(long newConflictStatus) {
        this.conflictStatus = BigInteger.valueOf(newConflictStatus);
        return this;
    }

    public GlusterHookBuilder conflictStatus(Long newConflictStatus) {
        this.conflictStatus = newConflictStatus == null ? null : BigInteger.valueOf(newConflictStatus);
        return this;
    }

    public GlusterHookBuilder conflictStatus(BigInteger newConflictStatus) {
        this.conflictStatus = newConflictStatus;
        return this;
    }

    public GlusterHookBuilder conflicts(String newConflicts) {
        this.conflicts = newConflicts;
        return this;
    }

    public GlusterHookBuilder content(String newContent) {
        this.content = newContent;
        return this;
    }

    public GlusterHookBuilder contentType(HookContentType newContentType) {
        this.contentType = newContentType;
        return this;
    }

    public GlusterHookBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public GlusterHookBuilder glusterCommand(String newGlusterCommand) {
        this.glusterCommand = newGlusterCommand;
        return this;
    }

    public GlusterHookBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public GlusterHookBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public GlusterHookBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public GlusterHookBuilder serverHooks(List<GlusterServerHook> newServerHooks) {
        if (newServerHooks != null) {
            if (this.serverHooks == null) {
                this.serverHooks = new ArrayList<GlusterServerHook>(newServerHooks);
            } else {
                this.serverHooks.addAll(newServerHooks);
            }
        }
        return this;
    }

    public GlusterHookBuilder serverHooks(GlusterServerHook ... newServerHooks) {
        if (newServerHooks != null) {
            if (this.serverHooks == null) {
                this.serverHooks = new ArrayList<GlusterServerHook>(newServerHooks.length);
            }
            Collections.addAll(this.serverHooks, newServerHooks);
        }
        return this;
    }

    public GlusterHookBuilder serverHooks(GlusterServerHookBuilder ... newServerHooks) {
        if (newServerHooks != null) {
            if (this.serverHooks == null) {
                this.serverHooks = new ArrayList<GlusterServerHook>(newServerHooks.length);
            }
            for (GlusterServerHookBuilder builder : newServerHooks) {
                this.serverHooks.add(builder.build());
            }
        }
        return this;
    }

    public GlusterHookBuilder stage(HookStage newStage) {
        this.stage = newStage;
        return this;
    }

    public GlusterHookBuilder status(GlusterHookStatus newStatus) {
        this.status = newStatus;
        return this;
    }

    public GlusterHook build() {
        GlusterHookContainer container = new GlusterHookContainer();
        container.checksum(this.checksum);
        container.cluster(this.cluster);
        container.comment(this.comment);
        container.conflictStatus(this.conflictStatus);
        container.conflicts(this.conflicts);
        container.content(this.content);
        container.contentType(this.contentType);
        container.description(this.description);
        container.glusterCommand(this.glusterCommand);
        container.href(this.href);
        container.id(this.id);
        container.name(this.name);
        container.serverHooks(this.serverHooks);
        container.stage(this.stage);
        container.status(this.status);
        return container;
    }
}

