/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.InstanceTypeBuilder;
import org.ovirt.engine.sdk4.builders.MacBuilder;
import org.ovirt.engine.sdk4.builders.NetworkAttachmentBuilder;
import org.ovirt.engine.sdk4.builders.NetworkBuilder;
import org.ovirt.engine.sdk4.builders.NetworkLabelBuilder;
import org.ovirt.engine.sdk4.builders.ReportedDeviceBuilder;
import org.ovirt.engine.sdk4.builders.StatisticBuilder;
import org.ovirt.engine.sdk4.builders.TemplateBuilder;
import org.ovirt.engine.sdk4.builders.VmBuilder;
import org.ovirt.engine.sdk4.builders.VnicProfileBuilder;
import org.ovirt.engine.sdk4.internal.containers.NicContainer;
import org.ovirt.engine.sdk4.types.BootProtocol;
import org.ovirt.engine.sdk4.types.InstanceType;
import org.ovirt.engine.sdk4.types.Mac;
import org.ovirt.engine.sdk4.types.Network;
import org.ovirt.engine.sdk4.types.NetworkAttachment;
import org.ovirt.engine.sdk4.types.NetworkLabel;
import org.ovirt.engine.sdk4.types.Nic;
import org.ovirt.engine.sdk4.types.NicInterface;
import org.ovirt.engine.sdk4.types.ReportedDevice;
import org.ovirt.engine.sdk4.types.Statistic;
import org.ovirt.engine.sdk4.types.Template;
import org.ovirt.engine.sdk4.types.Vm;
import org.ovirt.engine.sdk4.types.VnicProfile;

public class NicBuilder {
    private BootProtocol bootProtocol;
    private String comment;
    private String description;
    private String href;
    private String id;
    private InstanceType instanceType;
    private NicInterface interface_;
    private Boolean linked;
    private Mac mac;
    private String name;
    private Network network;
    private List<NetworkAttachment> networkAttachments;
    private List<NetworkLabel> networkLabels;
    private Boolean onBoot;
    private Boolean plugged;
    private List<ReportedDevice> reportedDevices;
    private List<Statistic> statistics;
    private Template template;
    private List<NetworkLabel> virtualFunctionAllowedLabels;
    private List<Network> virtualFunctionAllowedNetworks;
    private Vm vm;
    private List<Vm> vms;
    private VnicProfile vnicProfile;

    public NicBuilder bootProtocol(BootProtocol newBootProtocol) {
        this.bootProtocol = newBootProtocol;
        return this;
    }

    public NicBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public NicBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public NicBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public NicBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public NicBuilder instanceType(InstanceType newInstanceType) {
        this.instanceType = newInstanceType;
        return this;
    }

    public NicBuilder instanceType(InstanceTypeBuilder newInstanceType) {
        this.instanceType = newInstanceType == null ? null : newInstanceType.build();
        return this;
    }

    public NicBuilder interface_(NicInterface newInterface) {
        this.interface_ = newInterface;
        return this;
    }

    public NicBuilder linked(boolean newLinked) {
        this.linked = newLinked;
        return this;
    }

    public NicBuilder linked(Boolean newLinked) {
        this.linked = newLinked;
        return this;
    }

    public NicBuilder mac(Mac newMac) {
        this.mac = newMac;
        return this;
    }

    public NicBuilder mac(MacBuilder newMac) {
        this.mac = newMac == null ? null : newMac.build();
        return this;
    }

    public NicBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public NicBuilder network(Network newNetwork) {
        this.network = newNetwork;
        return this;
    }

    public NicBuilder network(NetworkBuilder newNetwork) {
        this.network = newNetwork == null ? null : newNetwork.build();
        return this;
    }

    public NicBuilder networkAttachments(List<NetworkAttachment> newNetworkAttachments) {
        if (newNetworkAttachments != null) {
            if (this.networkAttachments == null) {
                this.networkAttachments = new ArrayList<NetworkAttachment>(newNetworkAttachments);
            } else {
                this.networkAttachments.addAll(newNetworkAttachments);
            }
        }
        return this;
    }

    public NicBuilder networkAttachments(NetworkAttachment ... newNetworkAttachments) {
        if (newNetworkAttachments != null) {
            if (this.networkAttachments == null) {
                this.networkAttachments = new ArrayList<NetworkAttachment>(newNetworkAttachments.length);
            }
            Collections.addAll(this.networkAttachments, newNetworkAttachments);
        }
        return this;
    }

    public NicBuilder networkAttachments(NetworkAttachmentBuilder ... newNetworkAttachments) {
        if (newNetworkAttachments != null) {
            if (this.networkAttachments == null) {
                this.networkAttachments = new ArrayList<NetworkAttachment>(newNetworkAttachments.length);
            }
            for (NetworkAttachmentBuilder builder : newNetworkAttachments) {
                this.networkAttachments.add(builder.build());
            }
        }
        return this;
    }

    public NicBuilder networkLabels(List<NetworkLabel> newNetworkLabels) {
        if (newNetworkLabels != null) {
            if (this.networkLabels == null) {
                this.networkLabels = new ArrayList<NetworkLabel>(newNetworkLabels);
            } else {
                this.networkLabels.addAll(newNetworkLabels);
            }
        }
        return this;
    }

    public NicBuilder networkLabels(NetworkLabel ... newNetworkLabels) {
        if (newNetworkLabels != null) {
            if (this.networkLabels == null) {
                this.networkLabels = new ArrayList<NetworkLabel>(newNetworkLabels.length);
            }
            Collections.addAll(this.networkLabels, newNetworkLabels);
        }
        return this;
    }

    public NicBuilder networkLabels(NetworkLabelBuilder ... newNetworkLabels) {
        if (newNetworkLabels != null) {
            if (this.networkLabels == null) {
                this.networkLabels = new ArrayList<NetworkLabel>(newNetworkLabels.length);
            }
            for (NetworkLabelBuilder builder : newNetworkLabels) {
                this.networkLabels.add(builder.build());
            }
        }
        return this;
    }

    public NicBuilder onBoot(boolean newOnBoot) {
        this.onBoot = newOnBoot;
        return this;
    }

    public NicBuilder onBoot(Boolean newOnBoot) {
        this.onBoot = newOnBoot;
        return this;
    }

    public NicBuilder plugged(boolean newPlugged) {
        this.plugged = newPlugged;
        return this;
    }

    public NicBuilder plugged(Boolean newPlugged) {
        this.plugged = newPlugged;
        return this;
    }

    public NicBuilder reportedDevices(List<ReportedDevice> newReportedDevices) {
        if (newReportedDevices != null) {
            if (this.reportedDevices == null) {
                this.reportedDevices = new ArrayList<ReportedDevice>(newReportedDevices);
            } else {
                this.reportedDevices.addAll(newReportedDevices);
            }
        }
        return this;
    }

    public NicBuilder reportedDevices(ReportedDevice ... newReportedDevices) {
        if (newReportedDevices != null) {
            if (this.reportedDevices == null) {
                this.reportedDevices = new ArrayList<ReportedDevice>(newReportedDevices.length);
            }
            Collections.addAll(this.reportedDevices, newReportedDevices);
        }
        return this;
    }

    public NicBuilder reportedDevices(ReportedDeviceBuilder ... newReportedDevices) {
        if (newReportedDevices != null) {
            if (this.reportedDevices == null) {
                this.reportedDevices = new ArrayList<ReportedDevice>(newReportedDevices.length);
            }
            for (ReportedDeviceBuilder builder : newReportedDevices) {
                this.reportedDevices.add(builder.build());
            }
        }
        return this;
    }

    public NicBuilder statistics(List<Statistic> newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics);
            } else {
                this.statistics.addAll(newStatistics);
            }
        }
        return this;
    }

    public NicBuilder statistics(Statistic ... newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics.length);
            }
            Collections.addAll(this.statistics, newStatistics);
        }
        return this;
    }

    public NicBuilder statistics(StatisticBuilder ... newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics.length);
            }
            for (StatisticBuilder builder : newStatistics) {
                this.statistics.add(builder.build());
            }
        }
        return this;
    }

    public NicBuilder template(Template newTemplate) {
        this.template = newTemplate;
        return this;
    }

    public NicBuilder template(TemplateBuilder newTemplate) {
        this.template = newTemplate == null ? null : newTemplate.build();
        return this;
    }

    public NicBuilder virtualFunctionAllowedLabels(List<NetworkLabel> newVirtualFunctionAllowedLabels) {
        if (newVirtualFunctionAllowedLabels != null) {
            if (this.virtualFunctionAllowedLabels == null) {
                this.virtualFunctionAllowedLabels = new ArrayList<NetworkLabel>(newVirtualFunctionAllowedLabels);
            } else {
                this.virtualFunctionAllowedLabels.addAll(newVirtualFunctionAllowedLabels);
            }
        }
        return this;
    }

    public NicBuilder virtualFunctionAllowedLabels(NetworkLabel ... newVirtualFunctionAllowedLabels) {
        if (newVirtualFunctionAllowedLabels != null) {
            if (this.virtualFunctionAllowedLabels == null) {
                this.virtualFunctionAllowedLabels = new ArrayList<NetworkLabel>(newVirtualFunctionAllowedLabels.length);
            }
            Collections.addAll(this.virtualFunctionAllowedLabels, newVirtualFunctionAllowedLabels);
        }
        return this;
    }

    public NicBuilder virtualFunctionAllowedLabels(NetworkLabelBuilder ... newVirtualFunctionAllowedLabels) {
        if (newVirtualFunctionAllowedLabels != null) {
            if (this.virtualFunctionAllowedLabels == null) {
                this.virtualFunctionAllowedLabels = new ArrayList<NetworkLabel>(newVirtualFunctionAllowedLabels.length);
            }
            for (NetworkLabelBuilder builder : newVirtualFunctionAllowedLabels) {
                this.virtualFunctionAllowedLabels.add(builder.build());
            }
        }
        return this;
    }

    public NicBuilder virtualFunctionAllowedNetworks(List<Network> newVirtualFunctionAllowedNetworks) {
        if (newVirtualFunctionAllowedNetworks != null) {
            if (this.virtualFunctionAllowedNetworks == null) {
                this.virtualFunctionAllowedNetworks = new ArrayList<Network>(newVirtualFunctionAllowedNetworks);
            } else {
                this.virtualFunctionAllowedNetworks.addAll(newVirtualFunctionAllowedNetworks);
            }
        }
        return this;
    }

    public NicBuilder virtualFunctionAllowedNetworks(Network ... newVirtualFunctionAllowedNetworks) {
        if (newVirtualFunctionAllowedNetworks != null) {
            if (this.virtualFunctionAllowedNetworks == null) {
                this.virtualFunctionAllowedNetworks = new ArrayList<Network>(newVirtualFunctionAllowedNetworks.length);
            }
            Collections.addAll(this.virtualFunctionAllowedNetworks, newVirtualFunctionAllowedNetworks);
        }
        return this;
    }

    public NicBuilder virtualFunctionAllowedNetworks(NetworkBuilder ... newVirtualFunctionAllowedNetworks) {
        if (newVirtualFunctionAllowedNetworks != null) {
            if (this.virtualFunctionAllowedNetworks == null) {
                this.virtualFunctionAllowedNetworks = new ArrayList<Network>(newVirtualFunctionAllowedNetworks.length);
            }
            for (NetworkBuilder builder : newVirtualFunctionAllowedNetworks) {
                this.virtualFunctionAllowedNetworks.add(builder.build());
            }
        }
        return this;
    }

    public NicBuilder vm(Vm newVm) {
        this.vm = newVm;
        return this;
    }

    public NicBuilder vm(VmBuilder newVm) {
        this.vm = newVm == null ? null : newVm.build();
        return this;
    }

    public NicBuilder vms(List<Vm> newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms);
            } else {
                this.vms.addAll(newVms);
            }
        }
        return this;
    }

    public NicBuilder vms(Vm ... newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms.length);
            }
            Collections.addAll(this.vms, newVms);
        }
        return this;
    }

    public NicBuilder vms(VmBuilder ... newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms.length);
            }
            for (VmBuilder builder : newVms) {
                this.vms.add(builder.build());
            }
        }
        return this;
    }

    public NicBuilder vnicProfile(VnicProfile newVnicProfile) {
        this.vnicProfile = newVnicProfile;
        return this;
    }

    public NicBuilder vnicProfile(VnicProfileBuilder newVnicProfile) {
        this.vnicProfile = newVnicProfile == null ? null : newVnicProfile.build();
        return this;
    }

    public Nic build() {
        NicContainer container = new NicContainer();
        container.bootProtocol(this.bootProtocol);
        container.comment(this.comment);
        container.description(this.description);
        container.href(this.href);
        container.id(this.id);
        container.instanceType(this.instanceType);
        container.interface_(this.interface_);
        container.linked(this.linked);
        container.mac(this.mac);
        container.name(this.name);
        container.network(this.network);
        container.networkAttachments(this.networkAttachments);
        container.networkLabels(this.networkLabels);
        container.onBoot(this.onBoot);
        container.plugged(this.plugged);
        container.reportedDevices(this.reportedDevices);
        container.statistics(this.statistics);
        container.template(this.template);
        container.virtualFunctionAllowedLabels(this.virtualFunctionAllowedLabels);
        container.virtualFunctionAllowedNetworks(this.virtualFunctionAllowedNetworks);
        container.vm(this.vm);
        container.vms(this.vms);
        container.vnicProfile(this.vnicProfile);
        return container;
    }
}

