/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.BlockStatisticBuilder;
import org.ovirt.engine.sdk4.builders.FopStatisticBuilder;
import org.ovirt.engine.sdk4.builders.StatisticBuilder;
import org.ovirt.engine.sdk4.internal.containers.ProfileDetailContainer;
import org.ovirt.engine.sdk4.types.BlockStatistic;
import org.ovirt.engine.sdk4.types.FopStatistic;
import org.ovirt.engine.sdk4.types.ProfileDetail;
import org.ovirt.engine.sdk4.types.Statistic;

public class ProfileDetailBuilder {
    private List<BlockStatistic> blockStatistics;
    private BigInteger duration;
    private List<FopStatistic> fopStatistics;
    private String profileType;
    private List<Statistic> statistics;

    public ProfileDetailBuilder blockStatistics(List<BlockStatistic> newBlockStatistics) {
        if (newBlockStatistics != null) {
            if (this.blockStatistics == null) {
                this.blockStatistics = new ArrayList<BlockStatistic>(newBlockStatistics);
            } else {
                this.blockStatistics.addAll(newBlockStatistics);
            }
        }
        return this;
    }

    public ProfileDetailBuilder blockStatistics(BlockStatistic ... newBlockStatistics) {
        if (newBlockStatistics != null) {
            if (this.blockStatistics == null) {
                this.blockStatistics = new ArrayList<BlockStatistic>(newBlockStatistics.length);
            }
            Collections.addAll(this.blockStatistics, newBlockStatistics);
        }
        return this;
    }

    public ProfileDetailBuilder blockStatistics(BlockStatisticBuilder ... newBlockStatistics) {
        if (newBlockStatistics != null) {
            if (this.blockStatistics == null) {
                this.blockStatistics = new ArrayList<BlockStatistic>(newBlockStatistics.length);
            }
            for (BlockStatisticBuilder builder : newBlockStatistics) {
                this.blockStatistics.add(builder.build());
            }
        }
        return this;
    }

    public ProfileDetailBuilder duration(int newDuration) {
        this.duration = BigInteger.valueOf(newDuration);
        return this;
    }

    public ProfileDetailBuilder duration(Integer newDuration) {
        this.duration = newDuration == null ? null : BigInteger.valueOf(newDuration.longValue());
        return this;
    }

    public ProfileDetailBuilder duration(long newDuration) {
        this.duration = BigInteger.valueOf(newDuration);
        return this;
    }

    public ProfileDetailBuilder duration(Long newDuration) {
        this.duration = newDuration == null ? null : BigInteger.valueOf(newDuration);
        return this;
    }

    public ProfileDetailBuilder duration(BigInteger newDuration) {
        this.duration = newDuration;
        return this;
    }

    public ProfileDetailBuilder fopStatistics(List<FopStatistic> newFopStatistics) {
        if (newFopStatistics != null) {
            if (this.fopStatistics == null) {
                this.fopStatistics = new ArrayList<FopStatistic>(newFopStatistics);
            } else {
                this.fopStatistics.addAll(newFopStatistics);
            }
        }
        return this;
    }

    public ProfileDetailBuilder fopStatistics(FopStatistic ... newFopStatistics) {
        if (newFopStatistics != null) {
            if (this.fopStatistics == null) {
                this.fopStatistics = new ArrayList<FopStatistic>(newFopStatistics.length);
            }
            Collections.addAll(this.fopStatistics, newFopStatistics);
        }
        return this;
    }

    public ProfileDetailBuilder fopStatistics(FopStatisticBuilder ... newFopStatistics) {
        if (newFopStatistics != null) {
            if (this.fopStatistics == null) {
                this.fopStatistics = new ArrayList<FopStatistic>(newFopStatistics.length);
            }
            for (FopStatisticBuilder builder : newFopStatistics) {
                this.fopStatistics.add(builder.build());
            }
        }
        return this;
    }

    public ProfileDetailBuilder profileType(String newProfileType) {
        this.profileType = newProfileType;
        return this;
    }

    public ProfileDetailBuilder statistics(List<Statistic> newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics);
            } else {
                this.statistics.addAll(newStatistics);
            }
        }
        return this;
    }

    public ProfileDetailBuilder statistics(Statistic ... newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics.length);
            }
            Collections.addAll(this.statistics, newStatistics);
        }
        return this;
    }

    public ProfileDetailBuilder statistics(StatisticBuilder ... newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics.length);
            }
            for (StatisticBuilder builder : newStatistics) {
                this.statistics.add(builder.build());
            }
        }
        return this;
    }

    public ProfileDetail build() {
        ProfileDetailContainer container = new ProfileDetailContainer();
        container.blockStatistics(this.blockStatistics);
        container.duration(this.duration);
        container.fopStatistics(this.fopStatistics);
        container.profileType(this.profileType);
        container.statistics(this.statistics);
        return container;
    }
}

