/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.IpBuilder;
import org.ovirt.engine.sdk4.builders.MacBuilder;
import org.ovirt.engine.sdk4.builders.VmBuilder;
import org.ovirt.engine.sdk4.internal.containers.ReportedDeviceContainer;
import org.ovirt.engine.sdk4.types.Ip;
import org.ovirt.engine.sdk4.types.Mac;
import org.ovirt.engine.sdk4.types.ReportedDevice;
import org.ovirt.engine.sdk4.types.ReportedDeviceType;
import org.ovirt.engine.sdk4.types.Vm;

public class ReportedDeviceBuilder {
    private String comment;
    private String description;
    private String href;
    private String id;
    private List<Ip> ips;
    private Mac mac;
    private String name;
    private ReportedDeviceType type;
    private Vm vm;

    public ReportedDeviceBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public ReportedDeviceBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public ReportedDeviceBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public ReportedDeviceBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public ReportedDeviceBuilder ips(List<Ip> newIps) {
        if (newIps != null) {
            if (this.ips == null) {
                this.ips = new ArrayList<Ip>(newIps);
            } else {
                this.ips.addAll(newIps);
            }
        }
        return this;
    }

    public ReportedDeviceBuilder ips(Ip ... newIps) {
        if (newIps != null) {
            if (this.ips == null) {
                this.ips = new ArrayList<Ip>(newIps.length);
            }
            Collections.addAll(this.ips, newIps);
        }
        return this;
    }

    public ReportedDeviceBuilder ips(IpBuilder ... newIps) {
        if (newIps != null) {
            if (this.ips == null) {
                this.ips = new ArrayList<Ip>(newIps.length);
            }
            for (IpBuilder builder : newIps) {
                this.ips.add(builder.build());
            }
        }
        return this;
    }

    public ReportedDeviceBuilder mac(Mac newMac) {
        this.mac = newMac;
        return this;
    }

    public ReportedDeviceBuilder mac(MacBuilder newMac) {
        this.mac = newMac == null ? null : newMac.build();
        return this;
    }

    public ReportedDeviceBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public ReportedDeviceBuilder type(ReportedDeviceType newType) {
        this.type = newType;
        return this;
    }

    public ReportedDeviceBuilder vm(Vm newVm) {
        this.vm = newVm;
        return this;
    }

    public ReportedDeviceBuilder vm(VmBuilder newVm) {
        this.vm = newVm == null ? null : newVm.build();
        return this;
    }

    public ReportedDevice build() {
        ReportedDeviceContainer container = new ReportedDeviceContainer();
        container.comment(this.comment);
        container.description(this.description);
        container.href(this.href);
        container.id(this.id);
        container.ips(this.ips);
        container.mac(this.mac);
        container.name(this.name);
        container.type(this.type);
        container.vm(this.vm);
        return container;
    }
}

