/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.ovirt.engine.sdk4.builders.HostBuilder;
import org.ovirt.engine.sdk4.builders.JobBuilder;
import org.ovirt.engine.sdk4.builders.StatisticBuilder;
import org.ovirt.engine.sdk4.internal.containers.StepContainer;
import org.ovirt.engine.sdk4.types.ExternalSystemType;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.Job;
import org.ovirt.engine.sdk4.types.Statistic;
import org.ovirt.engine.sdk4.types.Step;
import org.ovirt.engine.sdk4.types.StepEnum;
import org.ovirt.engine.sdk4.types.StepStatus;

public class StepBuilder {
    private String comment;
    private String description;
    private Date endTime;
    private Host executionHost;
    private Boolean external;
    private ExternalSystemType externalType;
    private String href;
    private String id;
    private Job job;
    private String name;
    private BigInteger number;
    private Step parentStep;
    private BigInteger progress;
    private Date startTime;
    private List<Statistic> statistics;
    private StepStatus status;
    private StepEnum type;

    public StepBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public StepBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public StepBuilder endTime(Date newEndTime) {
        this.endTime = newEndTime == null ? null : new Date(newEndTime.getTime());
        return this;
    }

    public StepBuilder executionHost(Host newExecutionHost) {
        this.executionHost = newExecutionHost;
        return this;
    }

    public StepBuilder executionHost(HostBuilder newExecutionHost) {
        this.executionHost = newExecutionHost == null ? null : newExecutionHost.build();
        return this;
    }

    public StepBuilder external(boolean newExternal) {
        this.external = newExternal;
        return this;
    }

    public StepBuilder external(Boolean newExternal) {
        this.external = newExternal;
        return this;
    }

    public StepBuilder externalType(ExternalSystemType newExternalType) {
        this.externalType = newExternalType;
        return this;
    }

    public StepBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public StepBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public StepBuilder job(Job newJob) {
        this.job = newJob;
        return this;
    }

    public StepBuilder job(JobBuilder newJob) {
        this.job = newJob == null ? null : newJob.build();
        return this;
    }

    public StepBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public StepBuilder number(int newNumber) {
        this.number = BigInteger.valueOf(newNumber);
        return this;
    }

    public StepBuilder number(Integer newNumber) {
        this.number = newNumber == null ? null : BigInteger.valueOf(newNumber.longValue());
        return this;
    }

    public StepBuilder number(long newNumber) {
        this.number = BigInteger.valueOf(newNumber);
        return this;
    }

    public StepBuilder number(Long newNumber) {
        this.number = newNumber == null ? null : BigInteger.valueOf(newNumber);
        return this;
    }

    public StepBuilder number(BigInteger newNumber) {
        this.number = newNumber;
        return this;
    }

    public StepBuilder parentStep(Step newParentStep) {
        this.parentStep = newParentStep;
        return this;
    }

    public StepBuilder parentStep(StepBuilder newParentStep) {
        this.parentStep = newParentStep == null ? null : newParentStep.build();
        return this;
    }

    public StepBuilder progress(int newProgress) {
        this.progress = BigInteger.valueOf(newProgress);
        return this;
    }

    public StepBuilder progress(Integer newProgress) {
        this.progress = newProgress == null ? null : BigInteger.valueOf(newProgress.longValue());
        return this;
    }

    public StepBuilder progress(long newProgress) {
        this.progress = BigInteger.valueOf(newProgress);
        return this;
    }

    public StepBuilder progress(Long newProgress) {
        this.progress = newProgress == null ? null : BigInteger.valueOf(newProgress);
        return this;
    }

    public StepBuilder progress(BigInteger newProgress) {
        this.progress = newProgress;
        return this;
    }

    public StepBuilder startTime(Date newStartTime) {
        this.startTime = newStartTime == null ? null : new Date(newStartTime.getTime());
        return this;
    }

    public StepBuilder statistics(List<Statistic> newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics);
            } else {
                this.statistics.addAll(newStatistics);
            }
        }
        return this;
    }

    public StepBuilder statistics(Statistic ... newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics.length);
            }
            Collections.addAll(this.statistics, newStatistics);
        }
        return this;
    }

    public StepBuilder statistics(StatisticBuilder ... newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics.length);
            }
            for (StatisticBuilder builder : newStatistics) {
                this.statistics.add(builder.build());
            }
        }
        return this;
    }

    public StepBuilder status(StepStatus newStatus) {
        this.status = newStatus;
        return this;
    }

    public StepBuilder type(StepEnum newType) {
        this.type = newType;
        return this;
    }

    public Step build() {
        StepContainer container = new StepContainer();
        container.comment(this.comment);
        container.description(this.description);
        container.endTime(this.endTime);
        container.executionHost(this.executionHost);
        container.external(this.external);
        container.externalType(this.externalType);
        container.href(this.href);
        container.id(this.id);
        container.job(this.job);
        container.name(this.name);
        container.number(this.number);
        container.parentStep(this.parentStep);
        container.progress(this.progress);
        container.startTime(this.startTime);
        container.statistics(this.statistics);
        container.status(this.status);
        container.type(this.type);
        return container;
    }
}

