/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AccessProtocol {
    GLUSTER,
    NFS,
    CIFS;

    private static final Logger LOG;

    public String value() {
        return this.name().toLowerCase();
    }

    public static AccessProtocol fromValue(String value) {
        try {
            return AccessProtocol.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.error("The string '" + value + "' isn't a valid value for the 'AccessProtocol' enumerated type. Valid values are: 'gluster', 'nfs', 'cifs'.");
            return null;
        }
    }

    static {
        LOG = LoggerFactory.getLogger(AccessProtocol.class);
    }
}

