/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum StorageType {
    ISCSI,
    FCP,
    NFS,
    LOCALFS,
    POSIXFS,
    GLUSTERFS,
    GLANCE,
    CINDER;

    private static final Logger LOG;

    public String value() {
        return this.name().toLowerCase();
    }

    public static StorageType fromValue(String value) {
        try {
            return StorageType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.error("The string '" + value + "' isn't a valid value for the 'StorageType' enumerated type. Valid values are: 'iscsi', 'fcp', 'nfs', 'localfs', 'posixfs', 'glusterfs', 'glance', 'cinder'.");
            return null;
        }
    }

    static {
        LOG = LoggerFactory.getLogger(StorageType.class);
    }
}

