/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import org.ovirt.engine.sdk4.internal.containers.IoContainer;
import org.ovirt.engine.sdk4.types.Io;

public class IoBuilder {
    private BigInteger threads;
    
    public IoBuilder threads(int newThreads) {
        threads = BigInteger.valueOf((long) newThreads);
        return this;
    }
    
    public IoBuilder threads(Integer newThreads) {
        if (newThreads == null) {
            threads = null;
        }
        else {
            threads = BigInteger.valueOf(newThreads.longValue());
        }
        return this;
    }
    
    public IoBuilder threads(long newThreads) {
        threads = BigInteger.valueOf(newThreads);
        return this;
    }
    
    public IoBuilder threads(Long newThreads) {
        if (newThreads == null) {
            threads = null;
        }
        else {
            threads = BigInteger.valueOf(newThreads.longValue());
        }
        return this;
    }
    
    public IoBuilder threads(BigInteger newThreads) {
        threads = newThreads;
        return this;
    }
    
    
    public Io build() {
        IoContainer container = new IoContainer();
        container.threads(threads);
        return container;
    }
}
