/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.Boolean;
import org.ovirt.engine.sdk4.internal.containers.UsbContainer;
import org.ovirt.engine.sdk4.types.Usb;
import org.ovirt.engine.sdk4.types.UsbType;

public class UsbBuilder {
    private Boolean enabled;
    private UsbType type;
    
    public UsbBuilder enabled(boolean newEnabled) {
        enabled = Boolean.valueOf(newEnabled);
        return this;
    }
    
    public UsbBuilder enabled(Boolean newEnabled) {
        enabled = newEnabled;
        return this;
    }
    
    
    public UsbBuilder type(UsbType newType) {
        type = newType;
        return this;
    }
    
    
    public Usb build() {
        UsbContainer container = new UsbContainer();
        container.enabled(enabled);
        container.type(type);
        return container;
    }
}
