/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.String;
import java.math.BigInteger;
import org.ovirt.engine.sdk4.types.Ssh;
import org.ovirt.engine.sdk4.types.SshAuthenticationMethod;
import org.ovirt.engine.sdk4.types.User;

public class SshContainer extends IdentifiedContainer implements Ssh {
    private SshAuthenticationMethod authenticationMethod;
    private String fingerprint;
    private BigInteger port;
    private User user;
    
    public SshAuthenticationMethod authenticationMethod() {
        return authenticationMethod;
    }
    
    public void authenticationMethod(SshAuthenticationMethod newAuthenticationMethod) {
        authenticationMethod = newAuthenticationMethod;
    }
    
    public boolean authenticationMethodPresent() {
        return authenticationMethod != null;
    }
    
    public String fingerprint() {
        return fingerprint;
    }
    
    public void fingerprint(String newFingerprint) {
        fingerprint = newFingerprint;
    }
    
    public boolean fingerprintPresent() {
        return fingerprint != null;
    }
    
    public BigInteger port() {
        return port;
    }
    
    public void port(BigInteger newPort) {
        port = newPort;
    }
    
    public boolean portPresent() {
        return port != null;
    }
    
    public User user() {
        return user;
    }
    
    public void user(User newUser) {
        user = newUser;
    }
    
    public boolean userPresent() {
        return user != null;
    }
    
}
