/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.util.List;
import org.ovirt.engine.sdk4.types.Boot;
import org.ovirt.engine.sdk4.types.BootDevice;

public class BootContainer extends Container implements Boot {
    private List<BootDevice> devices;
    
    public List<BootDevice> devices() {
        return makeUnmodifiableList(devices);
    }
    
    public void devices(List<BootDevice> newDevices) {
        devices = makeArrayList(newDevices);
    }
    
    public boolean devicesPresent() {
        return devices != null && !devices.isEmpty();
    }
    
}
