/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.util.ListWithHref;
import org.ovirt.api.metamodel.runtime.util.UnmodifiableListWithHref;

public class Container {
    protected static <E> List<E> makeUnmodifiableList(List<E> original) {
        if (original == null) {
            return Collections.emptyList();
        }
        else {
            if (original instanceof ListWithHref) {
                return new UnmodifiableListWithHref((ListWithHref) original);
            }
            return Collections.unmodifiableList(original);
        }
    }
    
    protected static <E> List<E> makeArrayList(List<E> original) {
        if (original == null) {
            return Collections.emptyList();
        }
        else {
            if (original instanceof ListWithHref) {
                return new ArrayListWithHref<E>((ListWithHref) original);
            }
            return new ArrayList<E>(original);
        }
    }
}
