/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.ClusterBuilder;
import org.ovirt.engine.sdk4.builders.DisplayBuilder;
import org.ovirt.engine.sdk4.builders.InstanceTypeBuilder;
import org.ovirt.engine.sdk4.builders.PermissionBuilder;
import org.ovirt.engine.sdk4.builders.RngDeviceBuilder;
import org.ovirt.engine.sdk4.builders.TemplateBuilder;
import org.ovirt.engine.sdk4.builders.VmBuilder;
import org.ovirt.engine.sdk4.internal.containers.VmPoolContainer;
import org.ovirt.engine.sdk4.types.Cluster;
import org.ovirt.engine.sdk4.types.Display;
import org.ovirt.engine.sdk4.types.InstanceType;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.RngDevice;
import org.ovirt.engine.sdk4.types.Template;
import org.ovirt.engine.sdk4.types.Vm;
import org.ovirt.engine.sdk4.types.VmPool;
import org.ovirt.engine.sdk4.types.VmPoolType;

public class VmPoolBuilder {
    private Boolean autoStorageSelect;
    private Cluster cluster;
    private String comment;
    private String description;
    private Display display;
    private String href;
    private String id;
    private InstanceType instanceType;
    private BigInteger maxUserVms;
    private String name;
    private List<Permission> permissions;
    private BigInteger prestartedVms;
    private RngDevice rngDevice;
    private BigInteger size;
    private Boolean soundcardEnabled;
    private Boolean stateful;
    private Template template;
    private VmPoolType type;
    private Boolean useLatestTemplateVersion;
    private Vm vm;

    public VmPoolBuilder autoStorageSelect(boolean newAutoStorageSelect) {
        this.autoStorageSelect = newAutoStorageSelect;
        return this;
    }

    public VmPoolBuilder autoStorageSelect(Boolean newAutoStorageSelect) {
        this.autoStorageSelect = newAutoStorageSelect;
        return this;
    }

    public VmPoolBuilder cluster(Cluster newCluster) {
        this.cluster = newCluster;
        return this;
    }

    public VmPoolBuilder cluster(ClusterBuilder newCluster) {
        this.cluster = newCluster == null ? null : newCluster.build();
        return this;
    }

    public VmPoolBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public VmPoolBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public VmPoolBuilder display(Display newDisplay) {
        this.display = newDisplay;
        return this;
    }

    public VmPoolBuilder display(DisplayBuilder newDisplay) {
        this.display = newDisplay == null ? null : newDisplay.build();
        return this;
    }

    public VmPoolBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public VmPoolBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public VmPoolBuilder instanceType(InstanceType newInstanceType) {
        this.instanceType = newInstanceType;
        return this;
    }

    public VmPoolBuilder instanceType(InstanceTypeBuilder newInstanceType) {
        this.instanceType = newInstanceType == null ? null : newInstanceType.build();
        return this;
    }

    public VmPoolBuilder maxUserVms(int newMaxUserVms) {
        this.maxUserVms = BigInteger.valueOf(newMaxUserVms);
        return this;
    }

    public VmPoolBuilder maxUserVms(Integer newMaxUserVms) {
        this.maxUserVms = newMaxUserVms == null ? null : BigInteger.valueOf(newMaxUserVms.longValue());
        return this;
    }

    public VmPoolBuilder maxUserVms(long newMaxUserVms) {
        this.maxUserVms = BigInteger.valueOf(newMaxUserVms);
        return this;
    }

    public VmPoolBuilder maxUserVms(Long newMaxUserVms) {
        this.maxUserVms = newMaxUserVms == null ? null : BigInteger.valueOf(newMaxUserVms);
        return this;
    }

    public VmPoolBuilder maxUserVms(BigInteger newMaxUserVms) {
        this.maxUserVms = newMaxUserVms;
        return this;
    }

    public VmPoolBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public VmPoolBuilder permissions(List<Permission> newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions);
            } else {
                this.permissions.addAll(newPermissions);
            }
        }
        return this;
    }

    public VmPoolBuilder permissions(Permission ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            Collections.addAll(this.permissions, newPermissions);
        }
        return this;
    }

    public VmPoolBuilder permissions(PermissionBuilder ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            for (PermissionBuilder builder : newPermissions) {
                this.permissions.add(builder.build());
            }
        }
        return this;
    }

    public VmPoolBuilder prestartedVms(int newPrestartedVms) {
        this.prestartedVms = BigInteger.valueOf(newPrestartedVms);
        return this;
    }

    public VmPoolBuilder prestartedVms(Integer newPrestartedVms) {
        this.prestartedVms = newPrestartedVms == null ? null : BigInteger.valueOf(newPrestartedVms.longValue());
        return this;
    }

    public VmPoolBuilder prestartedVms(long newPrestartedVms) {
        this.prestartedVms = BigInteger.valueOf(newPrestartedVms);
        return this;
    }

    public VmPoolBuilder prestartedVms(Long newPrestartedVms) {
        this.prestartedVms = newPrestartedVms == null ? null : BigInteger.valueOf(newPrestartedVms);
        return this;
    }

    public VmPoolBuilder prestartedVms(BigInteger newPrestartedVms) {
        this.prestartedVms = newPrestartedVms;
        return this;
    }

    public VmPoolBuilder rngDevice(RngDevice newRngDevice) {
        this.rngDevice = newRngDevice;
        return this;
    }

    public VmPoolBuilder rngDevice(RngDeviceBuilder newRngDevice) {
        this.rngDevice = newRngDevice == null ? null : newRngDevice.build();
        return this;
    }

    public VmPoolBuilder size(int newSize) {
        this.size = BigInteger.valueOf(newSize);
        return this;
    }

    public VmPoolBuilder size(Integer newSize) {
        this.size = newSize == null ? null : BigInteger.valueOf(newSize.longValue());
        return this;
    }

    public VmPoolBuilder size(long newSize) {
        this.size = BigInteger.valueOf(newSize);
        return this;
    }

    public VmPoolBuilder size(Long newSize) {
        this.size = newSize == null ? null : BigInteger.valueOf(newSize);
        return this;
    }

    public VmPoolBuilder size(BigInteger newSize) {
        this.size = newSize;
        return this;
    }

    public VmPoolBuilder soundcardEnabled(boolean newSoundcardEnabled) {
        this.soundcardEnabled = newSoundcardEnabled;
        return this;
    }

    public VmPoolBuilder soundcardEnabled(Boolean newSoundcardEnabled) {
        this.soundcardEnabled = newSoundcardEnabled;
        return this;
    }

    public VmPoolBuilder stateful(boolean newStateful) {
        this.stateful = newStateful;
        return this;
    }

    public VmPoolBuilder stateful(Boolean newStateful) {
        this.stateful = newStateful;
        return this;
    }

    public VmPoolBuilder template(Template newTemplate) {
        this.template = newTemplate;
        return this;
    }

    public VmPoolBuilder template(TemplateBuilder newTemplate) {
        this.template = newTemplate == null ? null : newTemplate.build();
        return this;
    }

    public VmPoolBuilder type(VmPoolType newType) {
        this.type = newType;
        return this;
    }

    public VmPoolBuilder useLatestTemplateVersion(boolean newUseLatestTemplateVersion) {
        this.useLatestTemplateVersion = newUseLatestTemplateVersion;
        return this;
    }

    public VmPoolBuilder useLatestTemplateVersion(Boolean newUseLatestTemplateVersion) {
        this.useLatestTemplateVersion = newUseLatestTemplateVersion;
        return this;
    }

    public VmPoolBuilder vm(Vm newVm) {
        this.vm = newVm;
        return this;
    }

    public VmPoolBuilder vm(VmBuilder newVm) {
        this.vm = newVm == null ? null : newVm.build();
        return this;
    }

    public VmPool build() {
        VmPoolContainer container = new VmPoolContainer();
        container.autoStorageSelect(this.autoStorageSelect);
        container.cluster(this.cluster);
        container.comment(this.comment);
        container.description(this.description);
        container.display(this.display);
        container.href(this.href);
        container.id(this.id);
        container.instanceType(this.instanceType);
        container.maxUserVms(this.maxUserVms);
        container.name(this.name);
        container.permissions(this.permissions);
        container.prestartedVms(this.prestartedVms);
        container.rngDevice(this.rngDevice);
        container.size(this.size);
        container.soundcardEnabled(this.soundcardEnabled);
        container.stateful(this.stateful);
        container.template(this.template);
        container.type(this.type);
        container.useLatestTemplateVersion(this.useLatestTemplateVersion);
        container.vm(this.vm);
        return container;
    }
}

