/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.Boolean;
import java.lang.String;
import org.ovirt.engine.sdk4.internal.containers.ReportedConfigurationContainer;
import org.ovirt.engine.sdk4.types.ReportedConfiguration;

public class ReportedConfigurationBuilder {
    private String actualValue;
    private String expectedValue;
    private Boolean inSync;
    private String name;
    
    public ReportedConfigurationBuilder actualValue(String newActualValue) {
        actualValue = newActualValue;
        return this;
    }
    
    
    public ReportedConfigurationBuilder expectedValue(String newExpectedValue) {
        expectedValue = newExpectedValue;
        return this;
    }
    
    
    public ReportedConfigurationBuilder inSync(boolean newInSync) {
        inSync = Boolean.valueOf(newInSync);
        return this;
    }
    
    public ReportedConfigurationBuilder inSync(Boolean newInSync) {
        inSync = newInSync;
        return this;
    }
    
    
    public ReportedConfigurationBuilder name(String newName) {
        name = newName;
        return this;
    }
    
    
    public ReportedConfiguration build() {
        ReportedConfigurationContainer container = new ReportedConfigurationContainer();
        container.actualValue(actualValue);
        container.expectedValue(expectedValue);
        container.inSync(inSync);
        container.name(name);
        return container;
    }
}
