/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.util.Date;
import org.ovirt.engine.sdk4.internal.containers.ApiContainer;
import org.ovirt.engine.sdk4.types.Api;
import org.ovirt.engine.sdk4.types.ApiSummary;
import org.ovirt.engine.sdk4.types.ProductInfo;
import org.ovirt.engine.sdk4.types.SpecialObjects;

public class ApiBuilder {
    private ProductInfo productInfo;
    private SpecialObjects specialObjects;
    private ApiSummary summary;
    private Date time;
    
    public ApiBuilder productInfo(ProductInfo newProductInfo) {
        productInfo = newProductInfo;
        return this;
    }
    
    public ApiBuilder productInfo(ProductInfoBuilder newProductInfo) {
        if (newProductInfo == null) {
            productInfo = null;
        }
        else {
            productInfo = newProductInfo.build();
        }
        return this;
    }
    
    
    public ApiBuilder specialObjects(SpecialObjects newSpecialObjects) {
        specialObjects = newSpecialObjects;
        return this;
    }
    
    public ApiBuilder specialObjects(SpecialObjectsBuilder newSpecialObjects) {
        if (newSpecialObjects == null) {
            specialObjects = null;
        }
        else {
            specialObjects = newSpecialObjects.build();
        }
        return this;
    }
    
    
    public ApiBuilder summary(ApiSummary newSummary) {
        summary = newSummary;
        return this;
    }
    
    public ApiBuilder summary(ApiSummaryBuilder newSummary) {
        if (newSummary == null) {
            summary = null;
        }
        else {
            summary = newSummary.build();
        }
        return this;
    }
    
    
    public ApiBuilder time(Date newTime) {
        if (newTime == null) {
            time = null;
        }
        else {
            time = new Date(newTime.getTime());
        }
        return this;
    }
    
    
    public Api build() {
        ApiContainer container = new ApiContainer();
        container.productInfo(productInfo);
        container.specialObjects(specialObjects);
        container.summary(summary);
        container.time(time);
        return container;
    }
}
