/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.math.BigInteger;

/**
 * Type containing information related to virtual machines on a particular host.
 */
public interface VmSummary {
    BigInteger active();
    Byte activeAsByte();
    Short activeAsShort();
    Integer activeAsInteger();
    Long activeAsLong();
    
    boolean activePresent();
    
    BigInteger migrating();
    Byte migratingAsByte();
    Short migratingAsShort();
    Integer migratingAsInteger();
    Long migratingAsLong();
    
    boolean migratingPresent();
    
    BigInteger total();
    Byte totalAsByte();
    Short totalAsShort();
    Integer totalAsInteger();
    Long totalAsLong();
    
    boolean totalPresent();
    
}
