/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.DataCenterBuilder;
import org.ovirt.engine.sdk4.builders.DiskBuilder;
import org.ovirt.engine.sdk4.builders.PermissionBuilder;
import org.ovirt.engine.sdk4.builders.QuotaClusterLimitBuilder;
import org.ovirt.engine.sdk4.builders.QuotaStorageLimitBuilder;
import org.ovirt.engine.sdk4.builders.UserBuilder;
import org.ovirt.engine.sdk4.builders.VmBuilder;
import org.ovirt.engine.sdk4.internal.containers.QuotaContainer;
import org.ovirt.engine.sdk4.types.DataCenter;
import org.ovirt.engine.sdk4.types.Disk;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.Quota;
import org.ovirt.engine.sdk4.types.QuotaClusterLimit;
import org.ovirt.engine.sdk4.types.QuotaStorageLimit;
import org.ovirt.engine.sdk4.types.User;
import org.ovirt.engine.sdk4.types.Vm;

public class QuotaBuilder {
    private BigInteger clusterHardLimitPct;
    private BigInteger clusterSoftLimitPct;
    private String comment;
    private DataCenter dataCenter;
    private String description;
    private List<Disk> disks;
    private String href;
    private String id;
    private String name;
    private List<Permission> permissions;
    private List<QuotaClusterLimit> quotaClusterLimits;
    private List<QuotaStorageLimit> quotaStorageLimits;
    private BigInteger storageHardLimitPct;
    private BigInteger storageSoftLimitPct;
    private List<User> users;
    private List<Vm> vms;

    public QuotaBuilder clusterHardLimitPct(int newClusterHardLimitPct) {
        this.clusterHardLimitPct = BigInteger.valueOf(newClusterHardLimitPct);
        return this;
    }

    public QuotaBuilder clusterHardLimitPct(Integer newClusterHardLimitPct) {
        this.clusterHardLimitPct = newClusterHardLimitPct == null ? null : BigInteger.valueOf(newClusterHardLimitPct.longValue());
        return this;
    }

    public QuotaBuilder clusterHardLimitPct(long newClusterHardLimitPct) {
        this.clusterHardLimitPct = BigInteger.valueOf(newClusterHardLimitPct);
        return this;
    }

    public QuotaBuilder clusterHardLimitPct(Long newClusterHardLimitPct) {
        this.clusterHardLimitPct = newClusterHardLimitPct == null ? null : BigInteger.valueOf(newClusterHardLimitPct);
        return this;
    }

    public QuotaBuilder clusterHardLimitPct(BigInteger newClusterHardLimitPct) {
        this.clusterHardLimitPct = newClusterHardLimitPct;
        return this;
    }

    public QuotaBuilder clusterSoftLimitPct(int newClusterSoftLimitPct) {
        this.clusterSoftLimitPct = BigInteger.valueOf(newClusterSoftLimitPct);
        return this;
    }

    public QuotaBuilder clusterSoftLimitPct(Integer newClusterSoftLimitPct) {
        this.clusterSoftLimitPct = newClusterSoftLimitPct == null ? null : BigInteger.valueOf(newClusterSoftLimitPct.longValue());
        return this;
    }

    public QuotaBuilder clusterSoftLimitPct(long newClusterSoftLimitPct) {
        this.clusterSoftLimitPct = BigInteger.valueOf(newClusterSoftLimitPct);
        return this;
    }

    public QuotaBuilder clusterSoftLimitPct(Long newClusterSoftLimitPct) {
        this.clusterSoftLimitPct = newClusterSoftLimitPct == null ? null : BigInteger.valueOf(newClusterSoftLimitPct);
        return this;
    }

    public QuotaBuilder clusterSoftLimitPct(BigInteger newClusterSoftLimitPct) {
        this.clusterSoftLimitPct = newClusterSoftLimitPct;
        return this;
    }

    public QuotaBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public QuotaBuilder dataCenter(DataCenter newDataCenter) {
        this.dataCenter = newDataCenter;
        return this;
    }

    public QuotaBuilder dataCenter(DataCenterBuilder newDataCenter) {
        this.dataCenter = newDataCenter == null ? null : newDataCenter.build();
        return this;
    }

    public QuotaBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public QuotaBuilder disks(List<Disk> newDisks) {
        if (newDisks != null) {
            if (this.disks == null) {
                this.disks = new ArrayList<Disk>(newDisks);
            } else {
                this.disks.addAll(newDisks);
            }
        }
        return this;
    }

    public QuotaBuilder disks(Disk ... newDisks) {
        if (newDisks != null) {
            if (this.disks == null) {
                this.disks = new ArrayList<Disk>(newDisks.length);
            }
            Collections.addAll(this.disks, newDisks);
        }
        return this;
    }

    public QuotaBuilder disks(DiskBuilder ... newDisks) {
        if (newDisks != null) {
            if (this.disks == null) {
                this.disks = new ArrayList<Disk>(newDisks.length);
            }
            for (DiskBuilder builder : newDisks) {
                this.disks.add(builder.build());
            }
        }
        return this;
    }

    public QuotaBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public QuotaBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public QuotaBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public QuotaBuilder permissions(List<Permission> newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions);
            } else {
                this.permissions.addAll(newPermissions);
            }
        }
        return this;
    }

    public QuotaBuilder permissions(Permission ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            Collections.addAll(this.permissions, newPermissions);
        }
        return this;
    }

    public QuotaBuilder permissions(PermissionBuilder ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            for (PermissionBuilder builder : newPermissions) {
                this.permissions.add(builder.build());
            }
        }
        return this;
    }

    public QuotaBuilder quotaClusterLimits(List<QuotaClusterLimit> newQuotaClusterLimits) {
        if (newQuotaClusterLimits != null) {
            if (this.quotaClusterLimits == null) {
                this.quotaClusterLimits = new ArrayList<QuotaClusterLimit>(newQuotaClusterLimits);
            } else {
                this.quotaClusterLimits.addAll(newQuotaClusterLimits);
            }
        }
        return this;
    }

    public QuotaBuilder quotaClusterLimits(QuotaClusterLimit ... newQuotaClusterLimits) {
        if (newQuotaClusterLimits != null) {
            if (this.quotaClusterLimits == null) {
                this.quotaClusterLimits = new ArrayList<QuotaClusterLimit>(newQuotaClusterLimits.length);
            }
            Collections.addAll(this.quotaClusterLimits, newQuotaClusterLimits);
        }
        return this;
    }

    public QuotaBuilder quotaClusterLimits(QuotaClusterLimitBuilder ... newQuotaClusterLimits) {
        if (newQuotaClusterLimits != null) {
            if (this.quotaClusterLimits == null) {
                this.quotaClusterLimits = new ArrayList<QuotaClusterLimit>(newQuotaClusterLimits.length);
            }
            for (QuotaClusterLimitBuilder builder : newQuotaClusterLimits) {
                this.quotaClusterLimits.add(builder.build());
            }
        }
        return this;
    }

    public QuotaBuilder quotaStorageLimits(List<QuotaStorageLimit> newQuotaStorageLimits) {
        if (newQuotaStorageLimits != null) {
            if (this.quotaStorageLimits == null) {
                this.quotaStorageLimits = new ArrayList<QuotaStorageLimit>(newQuotaStorageLimits);
            } else {
                this.quotaStorageLimits.addAll(newQuotaStorageLimits);
            }
        }
        return this;
    }

    public QuotaBuilder quotaStorageLimits(QuotaStorageLimit ... newQuotaStorageLimits) {
        if (newQuotaStorageLimits != null) {
            if (this.quotaStorageLimits == null) {
                this.quotaStorageLimits = new ArrayList<QuotaStorageLimit>(newQuotaStorageLimits.length);
            }
            Collections.addAll(this.quotaStorageLimits, newQuotaStorageLimits);
        }
        return this;
    }

    public QuotaBuilder quotaStorageLimits(QuotaStorageLimitBuilder ... newQuotaStorageLimits) {
        if (newQuotaStorageLimits != null) {
            if (this.quotaStorageLimits == null) {
                this.quotaStorageLimits = new ArrayList<QuotaStorageLimit>(newQuotaStorageLimits.length);
            }
            for (QuotaStorageLimitBuilder builder : newQuotaStorageLimits) {
                this.quotaStorageLimits.add(builder.build());
            }
        }
        return this;
    }

    public QuotaBuilder storageHardLimitPct(int newStorageHardLimitPct) {
        this.storageHardLimitPct = BigInteger.valueOf(newStorageHardLimitPct);
        return this;
    }

    public QuotaBuilder storageHardLimitPct(Integer newStorageHardLimitPct) {
        this.storageHardLimitPct = newStorageHardLimitPct == null ? null : BigInteger.valueOf(newStorageHardLimitPct.longValue());
        return this;
    }

    public QuotaBuilder storageHardLimitPct(long newStorageHardLimitPct) {
        this.storageHardLimitPct = BigInteger.valueOf(newStorageHardLimitPct);
        return this;
    }

    public QuotaBuilder storageHardLimitPct(Long newStorageHardLimitPct) {
        this.storageHardLimitPct = newStorageHardLimitPct == null ? null : BigInteger.valueOf(newStorageHardLimitPct);
        return this;
    }

    public QuotaBuilder storageHardLimitPct(BigInteger newStorageHardLimitPct) {
        this.storageHardLimitPct = newStorageHardLimitPct;
        return this;
    }

    public QuotaBuilder storageSoftLimitPct(int newStorageSoftLimitPct) {
        this.storageSoftLimitPct = BigInteger.valueOf(newStorageSoftLimitPct);
        return this;
    }

    public QuotaBuilder storageSoftLimitPct(Integer newStorageSoftLimitPct) {
        this.storageSoftLimitPct = newStorageSoftLimitPct == null ? null : BigInteger.valueOf(newStorageSoftLimitPct.longValue());
        return this;
    }

    public QuotaBuilder storageSoftLimitPct(long newStorageSoftLimitPct) {
        this.storageSoftLimitPct = BigInteger.valueOf(newStorageSoftLimitPct);
        return this;
    }

    public QuotaBuilder storageSoftLimitPct(Long newStorageSoftLimitPct) {
        this.storageSoftLimitPct = newStorageSoftLimitPct == null ? null : BigInteger.valueOf(newStorageSoftLimitPct);
        return this;
    }

    public QuotaBuilder storageSoftLimitPct(BigInteger newStorageSoftLimitPct) {
        this.storageSoftLimitPct = newStorageSoftLimitPct;
        return this;
    }

    public QuotaBuilder users(List<User> newUsers) {
        if (newUsers != null) {
            if (this.users == null) {
                this.users = new ArrayList<User>(newUsers);
            } else {
                this.users.addAll(newUsers);
            }
        }
        return this;
    }

    public QuotaBuilder users(User ... newUsers) {
        if (newUsers != null) {
            if (this.users == null) {
                this.users = new ArrayList<User>(newUsers.length);
            }
            Collections.addAll(this.users, newUsers);
        }
        return this;
    }

    public QuotaBuilder users(UserBuilder ... newUsers) {
        if (newUsers != null) {
            if (this.users == null) {
                this.users = new ArrayList<User>(newUsers.length);
            }
            for (UserBuilder builder : newUsers) {
                this.users.add(builder.build());
            }
        }
        return this;
    }

    public QuotaBuilder vms(List<Vm> newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms);
            } else {
                this.vms.addAll(newVms);
            }
        }
        return this;
    }

    public QuotaBuilder vms(Vm ... newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms.length);
            }
            Collections.addAll(this.vms, newVms);
        }
        return this;
    }

    public QuotaBuilder vms(VmBuilder ... newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms.length);
            }
            for (VmBuilder builder : newVms) {
                this.vms.add(builder.build());
            }
        }
        return this;
    }

    public Quota build() {
        QuotaContainer container = new QuotaContainer();
        container.clusterHardLimitPct(this.clusterHardLimitPct);
        container.clusterSoftLimitPct(this.clusterSoftLimitPct);
        container.comment(this.comment);
        container.dataCenter(this.dataCenter);
        container.description(this.description);
        container.disks(this.disks);
        container.href(this.href);
        container.id(this.id);
        container.name(this.name);
        container.permissions(this.permissions);
        container.quotaClusterLimits(this.quotaClusterLimits);
        container.quotaStorageLimits(this.quotaStorageLimits);
        container.storageHardLimitPct(this.storageHardLimitPct);
        container.storageSoftLimitPct(this.storageSoftLimitPct);
        container.users(this.users);
        container.vms(this.vms);
        return container;
    }
}

