/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.decorators.ClusterAffinityGroups;
import org.ovirt.engine.sdk.decorators.ClusterCpuProfiles;
import org.ovirt.engine.sdk.decorators.ClusterGlusterHooks;
import org.ovirt.engine.sdk.decorators.ClusterGlusterVolumes;
import org.ovirt.engine.sdk.decorators.ClusterNetworks;
import org.ovirt.engine.sdk.decorators.ClusterPermissions;
import org.ovirt.engine.sdk.entities.Action;
import org.ovirt.engine.sdk.entities.Response;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class Cluster
extends org.ovirt.engine.sdk.entities.Cluster {
    private HttpProxyBroker proxy;
    private final Object LOCK = new Object();
    private volatile ClusterAffinityGroups clusterAffinityGroups;
    private volatile ClusterCpuProfiles clusterCpuProfiles;
    private volatile ClusterGlusterHooks clusterGlusterHooks;
    private volatile ClusterGlusterVolumes clusterGlusterVolumes;
    private volatile ClusterNetworks clusterNetworks;
    private volatile ClusterPermissions clusterPermissions;

    public Cluster(HttpProxyBroker proxy) {
        this.proxy = proxy;
    }

    private HttpProxyBroker getProxy() {
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterAffinityGroups getAffinityGroups() {
        if (this.clusterAffinityGroups == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.clusterAffinityGroups == null) {
                    this.clusterAffinityGroups = new ClusterAffinityGroups(this.proxy, this);
                }
            }
        }
        return this.clusterAffinityGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterCpuProfiles getCpuProfiles() {
        if (this.clusterCpuProfiles == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.clusterCpuProfiles == null) {
                    this.clusterCpuProfiles = new ClusterCpuProfiles(this.proxy, this);
                }
            }
        }
        return this.clusterCpuProfiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterGlusterHooks getGlusterHooks() {
        if (this.clusterGlusterHooks == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.clusterGlusterHooks == null) {
                    this.clusterGlusterHooks = new ClusterGlusterHooks(this.proxy, this);
                }
            }
        }
        return this.clusterGlusterHooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterGlusterVolumes getGlusterVolumes() {
        if (this.clusterGlusterVolumes == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.clusterGlusterVolumes == null) {
                    this.clusterGlusterVolumes = new ClusterGlusterVolumes(this.proxy, this);
                }
            }
        }
        return this.clusterGlusterVolumes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterNetworks getNetworks() {
        if (this.clusterNetworks == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.clusterNetworks == null) {
                    this.clusterNetworks = new ClusterNetworks(this.proxy, this);
                }
            }
        }
        return this.clusterNetworks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterPermissions getPermissions() {
        if (this.clusterPermissions == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.clusterPermissions == null) {
                    this.clusterPermissions = new ClusterPermissions(this.proxy, this);
                }
            }
        }
        return this.clusterPermissions;
    }

    public Response delete() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Action resetemulatedmachine(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/resetemulatedmachine";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action resetemulatedmachine(Action action, Boolean async) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/resetemulatedmachine";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action resetemulatedmachine(Action action, Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/resetemulatedmachine";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Cluster update() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().update(url, this, org.ovirt.engine.sdk.entities.Cluster.class, Cluster.class, headers);
    }

    public Cluster update(String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().update(url, this, org.ovirt.engine.sdk.entities.Cluster.class, Cluster.class, headers);
    }

    public Cluster update(String correlationId, Boolean async) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().update(url, this, org.ovirt.engine.sdk.entities.Cluster.class, Cluster.class, headers);
    }

    public Cluster update(String correlationId, Boolean async, String expect) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().update(url, this, org.ovirt.engine.sdk.entities.Cluster.class, Cluster.class, headers);
    }
}

