/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.Template;
import org.ovirt.engine.sdk.decorators.TemplateGraphicsConsole;
import org.ovirt.engine.sdk.entities.GraphicsConsole;
import org.ovirt.engine.sdk.entities.GraphicsConsoles;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class TemplateGraphicsConsoles
extends CollectionDecorator<GraphicsConsole, GraphicsConsoles, TemplateGraphicsConsole> {
    private Template parent;

    public TemplateGraphicsConsoles(HttpProxyBroker proxy, Template parent) {
        super(proxy, "graphicsconsoles");
        this.parent = parent;
    }

    @Override
    public List<TemplateGraphicsConsole> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, GraphicsConsoles.class, TemplateGraphicsConsole.class);
    }

    @Override
    public TemplateGraphicsConsole get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, GraphicsConsole.class, TemplateGraphicsConsole.class);
    }

    @Override
    public TemplateGraphicsConsole getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, GraphicsConsole.class, TemplateGraphicsConsole.class);
    }

    public TemplateGraphicsConsole add(GraphicsConsole graphicsconsole) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, graphicsconsole, GraphicsConsole.class, TemplateGraphicsConsole.class, headers);
    }

    public TemplateGraphicsConsole add(GraphicsConsole graphicsconsole, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, graphicsconsole, GraphicsConsole.class, TemplateGraphicsConsole.class, headers);
    }

    public TemplateGraphicsConsole add(GraphicsConsole graphicsconsole, String correlationId, String expect) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, graphicsconsole, GraphicsConsole.class, TemplateGraphicsConsole.class, headers);
    }

    public List<TemplateGraphicsConsole> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, GraphicsConsoles.class, TemplateGraphicsConsole.class, headers);
    }
}

