/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.DomainGroupsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.DomainUsersServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlDomainReader;
import org.ovirt.engine.sdk4.services.DomainGroupsService;
import org.ovirt.engine.sdk4.services.DomainService;
import org.ovirt.engine.sdk4.services.DomainUsersService;
import org.ovirt.engine.sdk4.types.Domain;

public class DomainServiceImpl
extends ServiceImpl
implements DomainService {
    public DomainServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public DomainService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public DomainGroupsService groupsService() {
        return new DomainGroupsServiceImpl(this.getConnection(), this.getPath() + "/groups");
    }

    @Override
    public DomainUsersService usersService() {
        return new DomainUsersServiceImpl(this.getConnection(), this.getPath() + "/users");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("groups")) {
            return this.groupsService();
        }
        if (path.startsWith("groups/")) {
            return this.groupsService().service(path.substring(7));
        }
        if (path.equals("users")) {
            return this.usersService();
        }
        if (path.startsWith("users/")) {
            return this.usersService().service(path.substring(6));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "DomainService:" + this.getPath();
    }

    private class GetResponseImpl
    implements DomainService.GetResponse {
        private Domain domain;

        private GetResponseImpl() {
        }

        public void domain(Domain domain) {
            this.domain = domain;
        }

        @Override
        public Domain domain() {
            return this.domain;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<DomainService.GetRequest, DomainService.GetResponse>
    implements DomainService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public DomainService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public DomainService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(DomainServiceImpl.this.getConnection().getUrl() + DomainServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = DomainServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.domain(XmlDomainReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            DomainServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

