/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.DiskProfileBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.DiskProfileServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskProfileReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskProfileWriter;
import org.ovirt.engine.sdk4.services.DiskProfileService;
import org.ovirt.engine.sdk4.services.DiskProfilesService;
import org.ovirt.engine.sdk4.types.DiskProfile;

public class DiskProfilesServiceImpl
extends ServiceImpl
implements DiskProfilesService {
    public DiskProfilesServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public DiskProfilesService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public DiskProfilesService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public DiskProfileService diskProfileService(String id) {
        return new DiskProfileServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.diskProfileService(path);
        }
        return this.diskProfileService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "DiskProfilesService:" + this.getPath();
    }

    private class ListResponseImpl
    implements DiskProfilesService.ListResponse {
        private List<DiskProfile> profile;

        private ListResponseImpl() {
        }

        public void profile(List<DiskProfile> profile) {
            this.profile = profile;
        }

        @Override
        public List<DiskProfile> profile() {
            return this.profile;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<DiskProfilesService.ListRequest, DiskProfilesService.ListResponse>
    implements DiskProfilesService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public DiskProfilesService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public DiskProfilesService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public DiskProfilesService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public DiskProfilesService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public DiskProfilesService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(DiskProfilesServiceImpl.this.getConnection().getUrl() + DiskProfilesServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = DiskProfilesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.profile(XmlDiskProfileReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            DiskProfilesServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements DiskProfilesService.AddResponse {
        private DiskProfile profile;

        private AddResponseImpl() {
        }

        public void profile(DiskProfile profile) {
            this.profile = profile;
        }

        @Override
        public DiskProfile profile() {
            return this.profile;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<DiskProfilesService.AddRequest, DiskProfilesService.AddResponse>
    implements DiskProfilesService.AddRequest {
        private DiskProfile profile;

        private AddRequestImpl() {
        }

        @Override
        public DiskProfilesService.AddRequest profile(DiskProfile profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public DiskProfilesService.AddRequest profile(DiskProfileBuilder profile) {
            this.profile = profile.build();
            return this;
        }

        @Override
        public DiskProfilesService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(DiskProfilesServiceImpl.this.getConnection().getUrl() + DiskProfilesServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlDiskProfileWriter.writeOne(this.profile, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = DiskProfilesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.profile(XmlDiskProfileReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            DiskProfilesServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

