/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum NotificationMethod {
    SMTP("smtp"),
    SNMP("snmp");

    private static final Logger log;
    private String image;

    private NotificationMethod(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static NotificationMethod fromValue(String value) {
        try {
            return NotificationMethod.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'NotificationMethod' enumerated type. Valid values are 'smtp' and 'snmp'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(NotificationMethod.class);
    }
}

