/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.String;
import java.math.BigInteger;
import org.ovirt.engine.sdk4.internal.containers.MDevTypeContainer;
import org.ovirt.engine.sdk4.types.MDevType;

public class MDevTypeBuilder {
    private BigInteger availableInstances;
    private String description;
    private String name;
    
    public MDevTypeBuilder availableInstances(int newAvailableInstances) {
        availableInstances = BigInteger.valueOf((long) newAvailableInstances);
        return this;
    }
    
    public MDevTypeBuilder availableInstances(Integer newAvailableInstances) {
        if (newAvailableInstances == null) {
            availableInstances = null;
        }
        else {
            availableInstances = BigInteger.valueOf(newAvailableInstances.longValue());
        }
        return this;
    }
    
    public MDevTypeBuilder availableInstances(long newAvailableInstances) {
        availableInstances = BigInteger.valueOf(newAvailableInstances);
        return this;
    }
    
    public MDevTypeBuilder availableInstances(Long newAvailableInstances) {
        if (newAvailableInstances == null) {
            availableInstances = null;
        }
        else {
            availableInstances = BigInteger.valueOf(newAvailableInstances.longValue());
        }
        return this;
    }
    
    public MDevTypeBuilder availableInstances(BigInteger newAvailableInstances) {
        availableInstances = newAvailableInstances;
        return this;
    }
    
    
    public MDevTypeBuilder description(String newDescription) {
        description = newDescription;
        return this;
    }
    
    
    public MDevTypeBuilder name(String newName) {
        name = newName;
        return this;
    }
    
    
    public MDevType build() {
        MDevTypeContainer container = new MDevTypeContainer();
        container.availableInstances(availableInstances);
        container.description(description);
        container.name(name);
        return container;
    }
}
