/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.StorageDomainBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.AttachedStorageDomainServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageDomainReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageDomainWriter;
import org.ovirt.engine.sdk4.services.AttachedStorageDomainService;
import org.ovirt.engine.sdk4.services.AttachedStorageDomainsService;
import org.ovirt.engine.sdk4.types.StorageDomain;

public class AttachedStorageDomainsServiceImpl
extends ServiceImpl
implements AttachedStorageDomainsService {
    public AttachedStorageDomainsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public AttachedStorageDomainsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public AttachedStorageDomainsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public AttachedStorageDomainService storageDomainService(String id) {
        return new AttachedStorageDomainServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.storageDomainService(path);
        }
        return this.storageDomainService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "AttachedStorageDomainsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements AttachedStorageDomainsService.ListResponse {
        private List<StorageDomain> storageDomains;

        private ListResponseImpl() {
        }

        public void storageDomains(List<StorageDomain> storageDomains) {
            this.storageDomains = storageDomains;
        }

        @Override
        public List<StorageDomain> storageDomains() {
            return this.storageDomains;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<AttachedStorageDomainsService.ListRequest, AttachedStorageDomainsService.ListResponse>
    implements AttachedStorageDomainsService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public AttachedStorageDomainsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public AttachedStorageDomainsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public AttachedStorageDomainsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public AttachedStorageDomainsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public AttachedStorageDomainsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AttachedStorageDomainsServiceImpl.this.getConnection().getUrl() + AttachedStorageDomainsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AttachedStorageDomainsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.storageDomains(XmlStorageDomainReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            AttachedStorageDomainsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements AttachedStorageDomainsService.AddResponse {
        private StorageDomain storageDomain;

        private AddResponseImpl() {
        }

        public void storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
        }

        @Override
        public StorageDomain storageDomain() {
            return this.storageDomain;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<AttachedStorageDomainsService.AddRequest, AttachedStorageDomainsService.AddResponse>
    implements AttachedStorageDomainsService.AddRequest {
        private StorageDomain storageDomain;

        private AddRequestImpl() {
        }

        @Override
        public AttachedStorageDomainsService.AddRequest storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
            return this;
        }

        @Override
        public AttachedStorageDomainsService.AddRequest storageDomain(StorageDomainBuilder storageDomain) {
            this.storageDomain = storageDomain.build();
            return this;
        }

        @Override
        public AttachedStorageDomainsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AttachedStorageDomainsServiceImpl.this.getConnection().getUrl() + AttachedStorageDomainsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlStorageDomainWriter.writeOne(this.storageDomain, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AttachedStorageDomainsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.storageDomain(XmlStorageDomainReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            AttachedStorageDomainsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

