/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.FileServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlFileReader;
import org.ovirt.engine.sdk4.services.FileService;
import org.ovirt.engine.sdk4.services.FilesService;
import org.ovirt.engine.sdk4.types.File;

public class FilesServiceImpl
extends ServiceImpl
implements FilesService {
    public FilesServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public FilesService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public FileService fileService(String id) {
        return new FileServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.fileService(path);
        }
        return this.fileService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "FilesService:" + this.getPath();
    }

    private class ListResponseImpl
    implements FilesService.ListResponse {
        private List<File> file;

        private ListResponseImpl() {
        }

        public void file(List<File> file) {
            this.file = file;
        }

        @Override
        public List<File> file() {
            return this.file;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<FilesService.ListRequest, FilesService.ListResponse>
    implements FilesService.ListRequest {
        private Boolean caseSensitive;
        private String follow;
        private BigInteger max;
        private Boolean refresh;
        private String search;

        private ListRequestImpl() {
        }

        @Override
        public FilesService.ListRequest caseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        @Override
        public FilesService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public FilesService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public FilesService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public FilesService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public FilesService.ListRequest refresh(Boolean refresh) {
            this.refresh = refresh;
            return this;
        }

        @Override
        public FilesService.ListRequest search(String search) {
            this.search = search;
            return this;
        }

        @Override
        public FilesService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(FilesServiceImpl.this.getConnection().getUrl() + FilesServiceImpl.this.getPath());
                if (this.caseSensitive != null) {
                    uriBuilder.addParameter("case_sensitive", XmlWriter.renderBoolean(this.caseSensitive));
                }
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.refresh != null) {
                    uriBuilder.addParameter("refresh", XmlWriter.renderBoolean(this.refresh));
                }
                if (this.search != null) {
                    uriBuilder.addParameter("search", XmlWriter.renderString(this.search));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = FilesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.file(XmlFileReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            FilesServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }
}

