/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.HostBuilder;
import org.ovirt.engine.sdk4.builders.MDevTypeBuilder;
import org.ovirt.engine.sdk4.builders.ProductBuilder;
import org.ovirt.engine.sdk4.builders.VendorBuilder;
import org.ovirt.engine.sdk4.builders.VmBuilder;
import org.ovirt.engine.sdk4.internal.containers.HostDeviceContainer;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.HostDevice;
import org.ovirt.engine.sdk4.types.MDevType;
import org.ovirt.engine.sdk4.types.Product;
import org.ovirt.engine.sdk4.types.Vendor;
import org.ovirt.engine.sdk4.types.Vm;

public class HostDeviceBuilder {
    private String capability;
    private String comment;
    private String description;
    private String driver;
    private Host host;
    private String href;
    private String id;
    private BigInteger iommuGroup;
    private List<MDevType> mDevTypes;
    private String name;
    private HostDevice parentDevice;
    private HostDevice physicalFunction;
    private Boolean placeholder;
    private Product product;
    private Vendor vendor;
    private BigInteger virtualFunctions;
    private Vm vm;

    public HostDeviceBuilder capability(String newCapability) {
        this.capability = newCapability;
        return this;
    }

    public HostDeviceBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public HostDeviceBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public HostDeviceBuilder driver(String newDriver) {
        this.driver = newDriver;
        return this;
    }

    public HostDeviceBuilder host(Host newHost) {
        this.host = newHost;
        return this;
    }

    public HostDeviceBuilder host(HostBuilder newHost) {
        this.host = newHost == null ? null : newHost.build();
        return this;
    }

    public HostDeviceBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public HostDeviceBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public HostDeviceBuilder iommuGroup(int newIommuGroup) {
        this.iommuGroup = BigInteger.valueOf(newIommuGroup);
        return this;
    }

    public HostDeviceBuilder iommuGroup(Integer newIommuGroup) {
        this.iommuGroup = newIommuGroup == null ? null : BigInteger.valueOf(newIommuGroup.longValue());
        return this;
    }

    public HostDeviceBuilder iommuGroup(long newIommuGroup) {
        this.iommuGroup = BigInteger.valueOf(newIommuGroup);
        return this;
    }

    public HostDeviceBuilder iommuGroup(Long newIommuGroup) {
        this.iommuGroup = newIommuGroup == null ? null : BigInteger.valueOf(newIommuGroup);
        return this;
    }

    public HostDeviceBuilder iommuGroup(BigInteger newIommuGroup) {
        this.iommuGroup = newIommuGroup;
        return this;
    }

    public HostDeviceBuilder mDevTypes(List<MDevType> newMDevTypes) {
        if (newMDevTypes != null) {
            if (this.mDevTypes == null) {
                this.mDevTypes = new ArrayList<MDevType>(newMDevTypes);
            } else {
                this.mDevTypes.addAll(newMDevTypes);
            }
        }
        return this;
    }

    public HostDeviceBuilder mDevTypes(MDevType ... newMDevTypes) {
        if (newMDevTypes != null) {
            if (this.mDevTypes == null) {
                this.mDevTypes = new ArrayList<MDevType>(newMDevTypes.length);
            }
            Collections.addAll(this.mDevTypes, newMDevTypes);
        }
        return this;
    }

    public HostDeviceBuilder mDevTypes(MDevTypeBuilder ... newMDevTypes) {
        if (newMDevTypes != null) {
            if (this.mDevTypes == null) {
                this.mDevTypes = new ArrayList<MDevType>(newMDevTypes.length);
            }
            for (MDevTypeBuilder builder : newMDevTypes) {
                this.mDevTypes.add(builder.build());
            }
        }
        return this;
    }

    public HostDeviceBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public HostDeviceBuilder parentDevice(HostDevice newParentDevice) {
        this.parentDevice = newParentDevice;
        return this;
    }

    public HostDeviceBuilder parentDevice(HostDeviceBuilder newParentDevice) {
        this.parentDevice = newParentDevice == null ? null : newParentDevice.build();
        return this;
    }

    public HostDeviceBuilder physicalFunction(HostDevice newPhysicalFunction) {
        this.physicalFunction = newPhysicalFunction;
        return this;
    }

    public HostDeviceBuilder physicalFunction(HostDeviceBuilder newPhysicalFunction) {
        this.physicalFunction = newPhysicalFunction == null ? null : newPhysicalFunction.build();
        return this;
    }

    public HostDeviceBuilder placeholder(boolean newPlaceholder) {
        this.placeholder = newPlaceholder;
        return this;
    }

    public HostDeviceBuilder placeholder(Boolean newPlaceholder) {
        this.placeholder = newPlaceholder;
        return this;
    }

    public HostDeviceBuilder product(Product newProduct) {
        this.product = newProduct;
        return this;
    }

    public HostDeviceBuilder product(ProductBuilder newProduct) {
        this.product = newProduct == null ? null : newProduct.build();
        return this;
    }

    public HostDeviceBuilder vendor(Vendor newVendor) {
        this.vendor = newVendor;
        return this;
    }

    public HostDeviceBuilder vendor(VendorBuilder newVendor) {
        this.vendor = newVendor == null ? null : newVendor.build();
        return this;
    }

    public HostDeviceBuilder virtualFunctions(int newVirtualFunctions) {
        this.virtualFunctions = BigInteger.valueOf(newVirtualFunctions);
        return this;
    }

    public HostDeviceBuilder virtualFunctions(Integer newVirtualFunctions) {
        this.virtualFunctions = newVirtualFunctions == null ? null : BigInteger.valueOf(newVirtualFunctions.longValue());
        return this;
    }

    public HostDeviceBuilder virtualFunctions(long newVirtualFunctions) {
        this.virtualFunctions = BigInteger.valueOf(newVirtualFunctions);
        return this;
    }

    public HostDeviceBuilder virtualFunctions(Long newVirtualFunctions) {
        this.virtualFunctions = newVirtualFunctions == null ? null : BigInteger.valueOf(newVirtualFunctions);
        return this;
    }

    public HostDeviceBuilder virtualFunctions(BigInteger newVirtualFunctions) {
        this.virtualFunctions = newVirtualFunctions;
        return this;
    }

    public HostDeviceBuilder vm(Vm newVm) {
        this.vm = newVm;
        return this;
    }

    public HostDeviceBuilder vm(VmBuilder newVm) {
        this.vm = newVm == null ? null : newVm.build();
        return this;
    }

    public HostDevice build() {
        HostDeviceContainer container = new HostDeviceContainer();
        container.capability(this.capability);
        container.comment(this.comment);
        container.description(this.description);
        container.driver(this.driver);
        container.host(this.host);
        container.href(this.href);
        container.id(this.id);
        container.iommuGroup(this.iommuGroup);
        container.mDevTypes(this.mDevTypes);
        container.name(this.name);
        container.parentDevice(this.parentDevice);
        container.physicalFunction(this.physicalFunction);
        container.placeholder(this.placeholder);
        container.product(this.product);
        container.vendor(this.vendor);
        container.virtualFunctions(this.virtualFunctions);
        container.vm(this.vm);
        return container;
    }
}

