/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ActionBuilder;
import org.ovirt.engine.sdk4.builders.VmPoolBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.AssignedPermissionsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlActionWriter;
import org.ovirt.engine.sdk4.internal.xml.XmlVmPoolReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVmPoolWriter;
import org.ovirt.engine.sdk4.services.AssignedPermissionsService;
import org.ovirt.engine.sdk4.services.VmPoolService;
import org.ovirt.engine.sdk4.types.Action;
import org.ovirt.engine.sdk4.types.VmPool;

public class VmPoolServiceImpl
extends ServiceImpl
implements VmPoolService {
    public VmPoolServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public VmPoolService.AllocateVmRequest allocateVm() {
        return new AllocateVmRequestImpl();
    }

    @Override
    public VmPoolService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public VmPoolService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public VmPoolService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public AssignedPermissionsService permissionsService() {
        return new AssignedPermissionsServiceImpl(this.getConnection(), this.getPath() + "/permissions");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("permissions")) {
            return this.permissionsService();
        }
        if (path.startsWith("permissions/")) {
            return this.permissionsService().service(path.substring(12));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "VmPoolService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements VmPoolService.UpdateResponse {
        private VmPool pool;

        private UpdateResponseImpl() {
        }

        public void pool(VmPool pool) {
            this.pool = pool;
        }

        @Override
        public VmPool pool() {
            return this.pool;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<VmPoolService.UpdateRequest, VmPoolService.UpdateResponse>
    implements VmPoolService.UpdateRequest {
        private Boolean async;
        private VmPool pool;

        private UpdateRequestImpl() {
        }

        @Override
        public VmPoolService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public VmPoolService.UpdateRequest pool(VmPool pool) {
            this.pool = pool;
            return this;
        }

        @Override
        public VmPoolService.UpdateRequest pool(VmPoolBuilder pool) {
            this.pool = pool.build();
            return this;
        }

        @Override
        public VmPoolService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmPoolServiceImpl.this.getConnection().getUrl() + VmPoolServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlVmPoolWriter.writeOne(this.pool, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmPoolServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.pool(XmlVmPoolReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmPoolServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements VmPoolService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<VmPoolService.RemoveRequest, VmPoolService.RemoveResponse>
    implements VmPoolService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public VmPoolService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public VmPoolService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmPoolServiceImpl.this.getConnection().getUrl() + VmPoolServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmPoolServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            VmPoolServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements VmPoolService.GetResponse {
        private VmPool pool;

        private GetResponseImpl() {
        }

        public void pool(VmPool pool) {
            this.pool = pool;
        }

        @Override
        public VmPool pool() {
            return this.pool;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<VmPoolService.GetRequest, VmPoolService.GetResponse>
    implements VmPoolService.GetRequest {
        private Boolean filter;
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public VmPoolService.GetRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public VmPoolService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public VmPoolService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmPoolServiceImpl.this.getConnection().getUrl() + VmPoolServiceImpl.this.getPath());
                if (this.filter != null) {
                    uriBuilder.addParameter("filter", XmlWriter.renderBoolean(this.filter));
                }
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmPoolServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.pool(XmlVmPoolReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmPoolServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }

    private class AllocateVmResponseImpl
    implements VmPoolService.AllocateVmResponse {
        private AllocateVmResponseImpl() {
        }
    }

    private class AllocateVmRequestImpl
    extends BaseRequest<VmPoolService.AllocateVmRequest, VmPoolService.AllocateVmResponse>
    implements VmPoolService.AllocateVmRequest {
        private Boolean async;

        private AllocateVmRequestImpl() {
        }

        @Override
        public VmPoolService.AllocateVmRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public VmPoolService.AllocateVmResponse send() {
            HttpPost request = new HttpPost(VmPoolServiceImpl.this.getConnection().getUrl() + VmPoolServiceImpl.this.getPath() + "/allocatevm");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = VmPoolServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = VmPoolServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new AllocateVmResponseImpl();
        }
    }
}

