/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum VmDeviceType {
    CDROM("cdrom"),
    FLOPPY("floppy");

    private static final Logger log;
    private String image;

    private VmDeviceType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static VmDeviceType fromValue(String value) {
        try {
            return VmDeviceType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'VmDeviceType' enumerated type. Valid values are 'cdrom' and 'floppy'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(VmDeviceType.class);
    }
}

