/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ActionBuilder;
import org.ovirt.engine.sdk4.builders.DiskBuilder;
import org.ovirt.engine.sdk4.builders.DiskProfileBuilder;
import org.ovirt.engine.sdk4.builders.HostBuilder;
import org.ovirt.engine.sdk4.builders.QuotaBuilder;
import org.ovirt.engine.sdk4.builders.StorageDomainBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.AssignedPermissionsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.DiskSnapshotsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.MeasurableServiceImpl;
import org.ovirt.engine.sdk4.internal.services.StatisticsServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlActionWriter;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskWriter;
import org.ovirt.engine.sdk4.services.AssignedPermissionsService;
import org.ovirt.engine.sdk4.services.DiskService;
import org.ovirt.engine.sdk4.services.DiskSnapshotsService;
import org.ovirt.engine.sdk4.services.StatisticsService;
import org.ovirt.engine.sdk4.types.Action;
import org.ovirt.engine.sdk4.types.Disk;
import org.ovirt.engine.sdk4.types.DiskProfile;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.Quota;
import org.ovirt.engine.sdk4.types.StorageDomain;

public class DiskServiceImpl
extends MeasurableServiceImpl
implements DiskService {
    public DiskServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public DiskService.CopyRequest copy() {
        return new CopyRequestImpl();
    }

    @Override
    public DiskService.ExportRequest export() {
        return new ExportRequestImpl();
    }

    @Override
    public DiskService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public DiskService.MoveRequest move() {
        return new MoveRequestImpl();
    }

    @Override
    public DiskService.ReduceRequest reduce() {
        return new ReduceRequestImpl();
    }

    @Override
    public DiskService.RefreshLunRequest refreshLun() {
        return new RefreshLunRequestImpl();
    }

    @Override
    public DiskService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public DiskService.SparsifyRequest sparsify() {
        return new SparsifyRequestImpl();
    }

    @Override
    public DiskService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public DiskSnapshotsService diskSnapshotsService() {
        return new DiskSnapshotsServiceImpl(this.getConnection(), this.getPath() + "/disksnapshots");
    }

    @Override
    public AssignedPermissionsService permissionsService() {
        return new AssignedPermissionsServiceImpl(this.getConnection(), this.getPath() + "/permissions");
    }

    @Override
    public StatisticsService statisticsService() {
        return new StatisticsServiceImpl(this.getConnection(), this.getPath() + "/statistics");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("disksnapshots")) {
            return this.diskSnapshotsService();
        }
        if (path.startsWith("disksnapshots/")) {
            return this.diskSnapshotsService().service(path.substring(14));
        }
        if (path.equals("permissions")) {
            return this.permissionsService();
        }
        if (path.startsWith("permissions/")) {
            return this.permissionsService().service(path.substring(12));
        }
        if (path.equals("statistics")) {
            return this.statisticsService();
        }
        if (path.startsWith("statistics/")) {
            return this.statisticsService().service(path.substring(11));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    @Override
    public String toString() {
        return "DiskService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements DiskService.UpdateResponse {
        private Disk disk;

        private UpdateResponseImpl() {
        }

        public void disk(Disk disk) {
            this.disk = disk;
        }

        @Override
        public Disk disk() {
            return this.disk;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<DiskService.UpdateRequest, DiskService.UpdateResponse>
    implements DiskService.UpdateRequest {
        private Disk disk;

        private UpdateRequestImpl() {
        }

        @Override
        public DiskService.UpdateRequest disk(Disk disk) {
            this.disk = disk;
            return this;
        }

        @Override
        public DiskService.UpdateRequest disk(DiskBuilder disk) {
            this.disk = disk.build();
            return this;
        }

        @Override
        public DiskService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(DiskServiceImpl.this.getConnection().getUrl() + DiskServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlDiskWriter.writeOne(this.disk, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = DiskServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.disk(XmlDiskReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            DiskServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class SparsifyResponseImpl
    implements DiskService.SparsifyResponse {
        private SparsifyResponseImpl() {
        }
    }

    private class SparsifyRequestImpl
    extends BaseRequest<DiskService.SparsifyRequest, DiskService.SparsifyResponse>
    implements DiskService.SparsifyRequest {
        private SparsifyRequestImpl() {
        }

        @Override
        public DiskService.SparsifyResponse send() {
            HttpPost request = new HttpPost(DiskServiceImpl.this.getConnection().getUrl() + DiskServiceImpl.this.getPath() + "/sparsify");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = DiskServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = DiskServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new SparsifyResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements DiskService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<DiskService.RemoveRequest, DiskService.RemoveResponse>
    implements DiskService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public DiskService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public DiskService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(DiskServiceImpl.this.getConnection().getUrl() + DiskServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = DiskServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            DiskServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class RefreshLunResponseImpl
    implements DiskService.RefreshLunResponse {
        private RefreshLunResponseImpl() {
        }
    }

    private class RefreshLunRequestImpl
    extends BaseRequest<DiskService.RefreshLunRequest, DiskService.RefreshLunResponse>
    implements DiskService.RefreshLunRequest {
        private Host host;

        private RefreshLunRequestImpl() {
        }

        @Override
        public DiskService.RefreshLunRequest host(Host host) {
            this.host = host;
            return this;
        }

        @Override
        public DiskService.RefreshLunRequest host(HostBuilder host) {
            this.host = host.build();
            return this;
        }

        @Override
        public DiskService.RefreshLunResponse send() {
            HttpPost request = new HttpPost(DiskServiceImpl.this.getConnection().getUrl() + DiskServiceImpl.this.getPath() + "/refreshlun");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.host(this.host);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = DiskServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = DiskServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new RefreshLunResponseImpl();
        }
    }

    private class ReduceResponseImpl
    implements DiskService.ReduceResponse {
        private ReduceResponseImpl() {
        }
    }

    private class ReduceRequestImpl
    extends BaseRequest<DiskService.ReduceRequest, DiskService.ReduceResponse>
    implements DiskService.ReduceRequest {
        private Boolean async;

        private ReduceRequestImpl() {
        }

        @Override
        public DiskService.ReduceRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public DiskService.ReduceResponse send() {
            HttpPost request = new HttpPost(DiskServiceImpl.this.getConnection().getUrl() + DiskServiceImpl.this.getPath() + "/reduce");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = DiskServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = DiskServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new ReduceResponseImpl();
        }
    }

    private class MoveResponseImpl
    implements DiskService.MoveResponse {
        private MoveResponseImpl() {
        }
    }

    private class MoveRequestImpl
    extends BaseRequest<DiskService.MoveRequest, DiskService.MoveResponse>
    implements DiskService.MoveRequest {
        private Boolean async;
        private DiskProfile diskProfile;
        private Boolean filter;
        private Quota quota;
        private StorageDomain storageDomain;

        private MoveRequestImpl() {
        }

        @Override
        public DiskService.MoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public DiskService.MoveRequest diskProfile(DiskProfile diskProfile) {
            this.diskProfile = diskProfile;
            return this;
        }

        @Override
        public DiskService.MoveRequest diskProfile(DiskProfileBuilder diskProfile) {
            this.diskProfile = diskProfile.build();
            return this;
        }

        @Override
        public DiskService.MoveRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public DiskService.MoveRequest quota(Quota quota) {
            this.quota = quota;
            return this;
        }

        @Override
        public DiskService.MoveRequest quota(QuotaBuilder quota) {
            this.quota = quota.build();
            return this;
        }

        @Override
        public DiskService.MoveRequest storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
            return this;
        }

        @Override
        public DiskService.MoveRequest storageDomain(StorageDomainBuilder storageDomain) {
            this.storageDomain = storageDomain.build();
            return this;
        }

        @Override
        public DiskService.MoveResponse send() {
            HttpPost request = new HttpPost(DiskServiceImpl.this.getConnection().getUrl() + DiskServiceImpl.this.getPath() + "/move");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                action.diskProfile(this.diskProfile);
                action.filter(this.filter);
                action.quota(this.quota);
                action.storageDomain(this.storageDomain);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = DiskServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = DiskServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new MoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements DiskService.GetResponse {
        private Disk disk;

        private GetResponseImpl() {
        }

        public void disk(Disk disk) {
            this.disk = disk;
        }

        @Override
        public Disk disk() {
            return this.disk;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<DiskService.GetRequest, DiskService.GetResponse>
    implements DiskService.GetRequest {
        private Boolean allContent;
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public DiskService.GetRequest allContent(Boolean allContent) {
            this.allContent = allContent;
            return this;
        }

        @Override
        public DiskService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public DiskService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(DiskServiceImpl.this.getConnection().getUrl() + DiskServiceImpl.this.getPath());
                if (this.allContent != null) {
                    uriBuilder.addParameter("all_content", XmlWriter.renderBoolean(this.allContent));
                }
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = DiskServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.disk(XmlDiskReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            DiskServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }

    private class ExportResponseImpl
    implements DiskService.ExportResponse {
        private ExportResponseImpl() {
        }
    }

    private class ExportRequestImpl
    extends BaseRequest<DiskService.ExportRequest, DiskService.ExportResponse>
    implements DiskService.ExportRequest {
        private Boolean async;
        private Boolean filter;
        private StorageDomain storageDomain;

        private ExportRequestImpl() {
        }

        @Override
        public DiskService.ExportRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public DiskService.ExportRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public DiskService.ExportRequest storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
            return this;
        }

        @Override
        public DiskService.ExportRequest storageDomain(StorageDomainBuilder storageDomain) {
            this.storageDomain = storageDomain.build();
            return this;
        }

        @Override
        public DiskService.ExportResponse send() {
            HttpPost request = new HttpPost(DiskServiceImpl.this.getConnection().getUrl() + DiskServiceImpl.this.getPath() + "/export");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                action.filter(this.filter);
                action.storageDomain(this.storageDomain);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = DiskServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = DiskServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new ExportResponseImpl();
        }
    }

    private class CopyResponseImpl
    implements DiskService.CopyResponse {
        private CopyResponseImpl() {
        }
    }

    private class CopyRequestImpl
    extends BaseRequest<DiskService.CopyRequest, DiskService.CopyResponse>
    implements DiskService.CopyRequest {
        private Boolean async;
        private Disk disk;
        private DiskProfile diskProfile;
        private Boolean filter;
        private Quota quota;
        private StorageDomain storageDomain;

        private CopyRequestImpl() {
        }

        @Override
        public DiskService.CopyRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public DiskService.CopyRequest disk(Disk disk) {
            this.disk = disk;
            return this;
        }

        @Override
        public DiskService.CopyRequest disk(DiskBuilder disk) {
            this.disk = disk.build();
            return this;
        }

        @Override
        public DiskService.CopyRequest diskProfile(DiskProfile diskProfile) {
            this.diskProfile = diskProfile;
            return this;
        }

        @Override
        public DiskService.CopyRequest diskProfile(DiskProfileBuilder diskProfile) {
            this.diskProfile = diskProfile.build();
            return this;
        }

        @Override
        public DiskService.CopyRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public DiskService.CopyRequest quota(Quota quota) {
            this.quota = quota;
            return this;
        }

        @Override
        public DiskService.CopyRequest quota(QuotaBuilder quota) {
            this.quota = quota.build();
            return this;
        }

        @Override
        public DiskService.CopyRequest storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
            return this;
        }

        @Override
        public DiskService.CopyRequest storageDomain(StorageDomainBuilder storageDomain) {
            this.storageDomain = storageDomain.build();
            return this;
        }

        @Override
        public DiskService.CopyResponse send() {
            HttpPost request = new HttpPost(DiskServiceImpl.this.getConnection().getUrl() + DiskServiceImpl.this.getPath() + "/copy");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                action.disk(this.disk);
                action.diskProfile(this.diskProfile);
                action.filter(this.filter);
                action.quota(this.quota);
                action.storageDomain(this.storageDomain);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = DiskServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = DiskServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new CopyResponseImpl();
        }
    }
}

