/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.UserOptionBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.UserOptionServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlUserOptionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlUserOptionWriter;
import org.ovirt.engine.sdk4.services.UserOptionService;
import org.ovirt.engine.sdk4.services.UserOptionsService;
import org.ovirt.engine.sdk4.types.UserOption;

public class UserOptionsServiceImpl
extends ServiceImpl
implements UserOptionsService {
    public UserOptionsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public UserOptionsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public UserOptionsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public UserOptionService optionService(String id) {
        return new UserOptionServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.optionService(path);
        }
        return this.optionService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "UserOptionsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements UserOptionsService.ListResponse {
        private List<UserOption> options;

        private ListResponseImpl() {
        }

        public void options(List<UserOption> options) {
            this.options = options;
        }

        @Override
        public List<UserOption> options() {
            return this.options;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<UserOptionsService.ListRequest, UserOptionsService.ListResponse>
    implements UserOptionsService.ListRequest {
        private ListRequestImpl() {
        }

        @Override
        public UserOptionsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(UserOptionsServiceImpl.this.getConnection().getUrl() + UserOptionsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = UserOptionsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.options(XmlUserOptionReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            UserOptionsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements UserOptionsService.AddResponse {
        private UserOption option;

        private AddResponseImpl() {
        }

        public void option(UserOption option) {
            this.option = option;
        }

        @Override
        public UserOption option() {
            return this.option;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<UserOptionsService.AddRequest, UserOptionsService.AddResponse>
    implements UserOptionsService.AddRequest {
        private UserOption option;

        private AddRequestImpl() {
        }

        @Override
        public UserOptionsService.AddRequest option(UserOption option) {
            this.option = option;
            return this;
        }

        @Override
        public UserOptionsService.AddRequest option(UserOptionBuilder option) {
            this.option = option.build();
            return this;
        }

        @Override
        public UserOptionsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(UserOptionsServiceImpl.this.getConnection().getUrl() + UserOptionsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlUserOptionWriter.writeOne(this.option, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = UserOptionsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.option(XmlUserOptionReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            UserOptionsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

