/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlExternalHostGroupReader;
import org.ovirt.engine.sdk4.services.ExternalHostGroupService;
import org.ovirt.engine.sdk4.types.ExternalHostGroup;

public class ExternalHostGroupServiceImpl
extends ServiceImpl
implements ExternalHostGroupService {
    public ExternalHostGroupServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public ExternalHostGroupService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "ExternalHostGroupService:" + this.getPath();
    }

    private class GetResponseImpl
    implements ExternalHostGroupService.GetResponse {
        private ExternalHostGroup group;

        private GetResponseImpl() {
        }

        public void group(ExternalHostGroup group) {
            this.group = group;
        }

        @Override
        public ExternalHostGroup group() {
            return this.group;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<ExternalHostGroupService.GetRequest, ExternalHostGroupService.GetResponse>
    implements ExternalHostGroupService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public ExternalHostGroupService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public ExternalHostGroupService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ExternalHostGroupServiceImpl.this.getConnection().getUrl() + ExternalHostGroupServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ExternalHostGroupServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.group(XmlExternalHostGroupReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ExternalHostGroupServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

