/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.Boolean;
import java.math.BigInteger;
import org.ovirt.engine.sdk4.types.HighAvailability;

public class HighAvailabilityContainer extends Container implements HighAvailability {
    private Boolean enabled;
    private BigInteger priority;
    
    public boolean enabled() {
        return enabled;
    }
    
    public void enabled(boolean newEnabled) {
        enabled = Boolean.valueOf(newEnabled);
    }
    
    public void enabled(Boolean newEnabled) {
        enabled = newEnabled;
    }
    
    public boolean enabledPresent() {
        return enabled != null;
    }
    
    public BigInteger priority() {
        return priority;
    }
    
    public Byte priorityAsByte() {
        return asByte("HighAvailability", "priority", priority);
    }
    
    public Short priorityAsShort() {
        return asShort("HighAvailability", "priority", priority);
    }
    
    public Integer priorityAsInteger() {
        return asInteger("HighAvailability", "priority", priority);
    }
    
    public Long priorityAsLong() {
        return asLong("HighAvailability", "priority", priority);
    }
    
    public void priority(BigInteger newPriority) {
        priority = newPriority;
    }
    
    public boolean priorityPresent() {
        return priority != null;
    }
    
}
