/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.FileBuilder;
import org.ovirt.engine.sdk4.internal.containers.PayloadContainer;
import org.ovirt.engine.sdk4.types.File;
import org.ovirt.engine.sdk4.types.Payload;
import org.ovirt.engine.sdk4.types.VmDeviceType;

public class PayloadBuilder {
    private List<File> files;
    private VmDeviceType type;
    private String volumeId;

    public PayloadBuilder files(List<File> newFiles) {
        if (newFiles != null) {
            if (this.files == null) {
                this.files = new ArrayList<File>(newFiles);
            } else {
                this.files.addAll(newFiles);
            }
        }
        return this;
    }

    public PayloadBuilder files(File ... newFiles) {
        if (newFiles != null) {
            if (this.files == null) {
                this.files = new ArrayList<File>(newFiles.length);
            }
            Collections.addAll(this.files, newFiles);
        }
        return this;
    }

    public PayloadBuilder files(FileBuilder ... newFiles) {
        if (newFiles != null) {
            if (this.files == null) {
                this.files = new ArrayList<File>(newFiles.length);
            }
            for (FileBuilder builder : newFiles) {
                this.files.add(builder.build());
            }
        }
        return this;
    }

    public PayloadBuilder type(VmDeviceType newType) {
        this.type = newType;
        return this;
    }

    public PayloadBuilder volumeId(String newVolumeId) {
        this.volumeId = newVolumeId;
        return this;
    }

    public Payload build() {
        PayloadContainer container = new PayloadContainer();
        container.files(this.files);
        container.type(this.type);
        container.volumeId(this.volumeId);
        return container;
    }
}

