/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthSchemeRegistry;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.DecompressingHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.ovirt.engine.sdk4.ConnectionBuilder;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.HttpClient;
import org.ovirt.engine.sdk4.internal.HttpClient42;

public class ConnectionBuilder42
extends ConnectionBuilder {
    private static final String UNRECOVERABLE_KEY_ERROR = "Unrecoverable key error has occured.";

    @Override
    protected HttpClient createHttpClient() {
        int port = this.getPort();
        Credentials credentials = null;
        AuthSchemeRegistry schemeRegistry = new AuthSchemeRegistry();
        AuthScope authScope = new AuthScope(this.getHost(), port, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
        if (this.user != null && this.user.length() > 0) {
            schemeRegistry.register("Basic", (AuthSchemeFactory)new BasicSchemeFactory());
            credentials = new UsernamePasswordCredentials(this.user, this.password);
        } else if (this.kerberos) {
            schemeRegistry.register("Negotiate", (AuthSchemeFactory)new SPNegoSchemeFactory(true));
            credentials = new Credentials(){

                public Principal getUserPrincipal() {
                    return null;
                }

                public String getPassword() {
                    return null;
                }
            };
        }
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)new PoolingClientConnectionManager(this.createConnectionSocketFactoryRegistry()));
        client.setAuthSchemes(schemeRegistry);
        client.getCredentialsProvider().setCredentials(authScope, credentials);
        client.getParams().setParameter("http.protocol.cookie-policy", (Object)"ignoreCookies");
        if (this.timeout != -1) {
            HttpConnectionParams.setSoTimeout((HttpParams)client.getParams(), (int)this.timeout);
        }
        if (this.compress) {
            return new HttpClient42(new DecompressingHttpClient((org.apache.http.client.HttpClient)client));
        }
        return new HttpClient42(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemeRegistry createConnectionSocketFactoryRegistry() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        if (HTTP_PROTOCOL.equals(this.getProtocol())) {
            schemeRegistry.register(new Scheme(HTTP_PROTOCOL, this.getPort(), (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        } else if (HTTPS_PROTOCOL.equals(this.getProtocol())) {
            try {
                SSLSocketFactory sf;
                if (this.insecure) {
                    SSLContext sslcontext = SSLContext.getInstance("TLS");
                    sslcontext.init(null, new TrustManager[]{this.noCaTrustManager}, null);
                    sf = new SSLSocketFactory(sslcontext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                } else {
                    KeyStore truststore = null;
                    FileInputStream in = null;
                    if (this.trustStoreFile != null) {
                        truststore = KeyStore.getInstance(KeyStore.getDefaultType());
                        try {
                            in = new FileInputStream(this.trustStoreFile);
                            truststore.load(in, this.trustStorePassword != null ? this.trustStorePassword.toCharArray() : null);
                        }
                        finally {
                            if (in != null) {
                                ((InputStream)in).close();
                            }
                        }
                    }
                    sf = new SSLSocketFactory("TLS", null, null, truststore, null, null, SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
                }
                schemeRegistry.register(new Scheme(HTTPS_PROTOCOL, this.getPort(), (SchemeSocketFactory)sf));
            }
            catch (NoSuchAlgorithmException e) {
                throw new Error("SSL context initiation has failed locating TLS algorithm.", e);
            }
            catch (KeyManagementException e) {
                throw new Error("SSL context initiation has failed because of key error.", e);
            }
            catch (KeyStoreException e) {
                throw new Error("CA certificate keystore initiation has failed.", e);
            }
            catch (FileNotFoundException e) {
                throw new Error("CA certificate keystore was not found.", e);
            }
            catch (CertificateException e) {
                throw new Error("CA certificate error.", e);
            }
            catch (IOException e) {
                throw new Error("I/O error occurred, is your keystore password correct?", e);
            }
            catch (UnrecoverableKeyException e) {
                throw new Error(UNRECOVERABLE_KEY_ERROR, e);
            }
        }
        return schemeRegistry;
    }
}

