/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.GlusterVolumeBuilder;
import org.ovirt.engine.sdk4.types.GlusterVolume;

public interface GlusterVolumesService extends Service {
    /**
     * Creates a new Gluster volume and adds it to the database. The volume is created based on properties of the
     * `volume` parameter. The properties `name`, `volumeType` and `bricks` are required.
     */
    public interface AddRequest extends Request<AddRequest, AddResponse> {
        AddRequest volume(GlusterVolume volume);
        /**
         * The Gluster volume definition from which to create the volume is passed as input and the newly created
         * volume is returned.
         */
        AddRequest volume(GlusterVolumeBuilder volume);
    }
    
    /**
     * Creates a new Gluster volume and adds it to the database. The volume is created based on properties of the
     * `volume` parameter. The properties `name`, `volumeType` and `bricks` are required.
     */
    public interface AddResponse extends Response {
        /**
         * The Gluster volume definition from which to create the volume is passed as input and the newly created
         * volume is returned.
         */
        GlusterVolume volume();
    }
    
    /**
     * Creates a new Gluster volume and adds it to the database. The volume is created based on properties of the
     * `volume` parameter. The properties `name`, `volumeType` and `bricks` are required.
     */
    AddRequest add();
    
    public interface ListRequest extends Request<ListRequest, ListResponse> {
        /**
         * Indicates if the search performed using the `search` parameter should be performed taking case into
         * account. The default value is `true`, which means that case is taken into account. If you want to search
         * ignoring case set it to `false`.
         */
        ListRequest caseSensitive(Boolean caseSensitive);
        /**
         * Sets the maximum number of volumes to return. If not specified all the volumes are returned.
         */
        ListRequest max(Integer max);
        /**
         * Sets the maximum number of volumes to return. If not specified all the volumes are returned.
         */
        ListRequest max(Long max);
        /**
         * Sets the maximum number of volumes to return. If not specified all the volumes are returned.
         */
        ListRequest max(BigInteger max);
        /**
         * A query string used to restrict the returned volumes.
         */
        ListRequest search(String search);
    }
    
    public interface ListResponse extends Response {
        List<GlusterVolume> volumes();
    }
    
    ListRequest list();
    
    GlusterVolumeService volumeService(String id);
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

