/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.UserBuilder;
import org.ovirt.engine.sdk4.types.User;

public interface UsersService extends Service {
    /**
     * Add user from a directory service.
     * 
     * For example, to add the `myuser` user from the `myextension-authz` authorization provider send a request
     * like this:
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/users
     * ----
     * 
     * With a request body like this:
     * 
     * [source,xml]
     * ----
     * <user>
     *   <user_name>myuser@myextension-authz</user_name>
     *   <domain>
     *     <name>myextension-authz</name>
     *   </domain>
     * </user>
     * ----
     * 
     * In case you are working with Active Directory you have to pass user principal name (UPN) as `username`, followed
     * by authorization provider name. Due to https://bugzilla.redhat.com/1147900[bug 1147900] you need to provide
     * also `principal` parameter set to UPN of the user.
     * 
     * For example, to add the user with UPN `myuser@mysubdomain.mydomain.com` from the `myextension-authz`
     * authorization provider send a request body like this:
     * 
     * [source,xml]
     * ----
     * <user>
     *   <principal>myuser@mysubdomain.mydomain.com</principal>
     *   <user_name>myuser@mysubdomain.mydomain.com@myextension-authz</user_name>
     *   <domain>
     *     <name>myextension-authz</name>
     *   </domain>
     * </user>
     * ----
     */
    public interface AddRequest extends Request<AddRequest, AddResponse> {
        AddRequest user(User user);
        AddRequest user(UserBuilder user);
    }
    
    /**
     * Add user from a directory service.
     * 
     * For example, to add the `myuser` user from the `myextension-authz` authorization provider send a request
     * like this:
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/users
     * ----
     * 
     * With a request body like this:
     * 
     * [source,xml]
     * ----
     * <user>
     *   <user_name>myuser@myextension-authz</user_name>
     *   <domain>
     *     <name>myextension-authz</name>
     *   </domain>
     * </user>
     * ----
     * 
     * In case you are working with Active Directory you have to pass user principal name (UPN) as `username`, followed
     * by authorization provider name. Due to https://bugzilla.redhat.com/1147900[bug 1147900] you need to provide
     * also `principal` parameter set to UPN of the user.
     * 
     * For example, to add the user with UPN `myuser@mysubdomain.mydomain.com` from the `myextension-authz`
     * authorization provider send a request body like this:
     * 
     * [source,xml]
     * ----
     * <user>
     *   <principal>myuser@mysubdomain.mydomain.com</principal>
     *   <user_name>myuser@mysubdomain.mydomain.com@myextension-authz</user_name>
     *   <domain>
     *     <name>myextension-authz</name>
     *   </domain>
     * </user>
     * ----
     */
    public interface AddResponse extends Response {
        User user();
    }
    
    /**
     * Add user from a directory service.
     * 
     * For example, to add the `myuser` user from the `myextension-authz` authorization provider send a request
     * like this:
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/users
     * ----
     * 
     * With a request body like this:
     * 
     * [source,xml]
     * ----
     * <user>
     *   <user_name>myuser@myextension-authz</user_name>
     *   <domain>
     *     <name>myextension-authz</name>
     *   </domain>
     * </user>
     * ----
     * 
     * In case you are working with Active Directory you have to pass user principal name (UPN) as `username`, followed
     * by authorization provider name. Due to https://bugzilla.redhat.com/1147900[bug 1147900] you need to provide
     * also `principal` parameter set to UPN of the user.
     * 
     * For example, to add the user with UPN `myuser@mysubdomain.mydomain.com` from the `myextension-authz`
     * authorization provider send a request body like this:
     * 
     * [source,xml]
     * ----
     * <user>
     *   <principal>myuser@mysubdomain.mydomain.com</principal>
     *   <user_name>myuser@mysubdomain.mydomain.com@myextension-authz</user_name>
     *   <domain>
     *     <name>myextension-authz</name>
     *   </domain>
     * </user>
     * ----
     */
    AddRequest add();
    
    public interface ListRequest extends Request<ListRequest, ListResponse> {
        /**
         * Indicates if the search performed using the `search` parameter should be performed taking case into
         * account. The default value is `true`, which means that case is taken into account. If you want to search
         * ignoring case set it to `false`.
         */
        ListRequest caseSensitive(Boolean caseSensitive);
        /**
         * Sets the maximum number of users to return. If not specified all the users are returned.
         */
        ListRequest max(Integer max);
        /**
         * Sets the maximum number of users to return. If not specified all the users are returned.
         */
        ListRequest max(Long max);
        /**
         * Sets the maximum number of users to return. If not specified all the users are returned.
         */
        ListRequest max(BigInteger max);
        /**
         * A query string used to restrict the returned users.
         */
        ListRequest search(String search);
    }
    
    public interface ListResponse extends Response {
        List<User> users();
    }
    
    ListRequest list();
    
    UserService userService(String id);
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

