/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.OptionBuilder;
import org.ovirt.engine.sdk4.types.GlusterVolume;
import org.ovirt.engine.sdk4.types.GlusterVolumeProfileDetails;
import org.ovirt.engine.sdk4.types.Option;

public interface GlusterVolumeService extends Service {
    public interface GetRequest extends Request<GetRequest, GetResponse> {
    }
    
    public interface GetResponse extends Response {
        GlusterVolume volume();
    }
    
    GetRequest get();
    
    public interface GetProfileStatisticsRequest extends Request<GetProfileStatisticsRequest, GetProfileStatisticsResponse> {
    }
    
    public interface GetProfileStatisticsResponse extends Response {
        GlusterVolumeProfileDetails details();
    }
    
    GetProfileStatisticsRequest getProfileStatistics();
    
    public interface RebalanceRequest extends Request<RebalanceRequest, RebalanceResponse> {
        /**
         * Indicates if the rebalance should be performed asynchronously.
         */
        RebalanceRequest async(Boolean async);
        RebalanceRequest fixLayout(Boolean fixLayout);
        RebalanceRequest force(Boolean force);
    }
    
    public interface RebalanceResponse extends Response {
    }
    
    RebalanceRequest rebalance();
    
    public interface RemoveRequest extends Request<RemoveRequest, RemoveResponse> {
        /**
         * Indicates if the remove should be performed asynchronously.
         */
        RemoveRequest async(Boolean async);
    }
    
    public interface RemoveResponse extends Response {
    }
    
    RemoveRequest remove();
    
    public interface ResetAllOptionsRequest extends Request<ResetAllOptionsRequest, ResetAllOptionsResponse> {
        /**
         * Indicates if the reset should be performed asynchronously.
         */
        ResetAllOptionsRequest async(Boolean async);
    }
    
    public interface ResetAllOptionsResponse extends Response {
    }
    
    ResetAllOptionsRequest resetAllOptions();
    
    public interface ResetOptionRequest extends Request<ResetOptionRequest, ResetOptionResponse> {
        /**
         * Indicates if the reset should be performed asynchronously.
         */
        ResetOptionRequest async(Boolean async);
        ResetOptionRequest force(Boolean force);
        ResetOptionRequest option(Option option);
        ResetOptionRequest option(OptionBuilder option);
    }
    
    public interface ResetOptionResponse extends Response {
    }
    
    ResetOptionRequest resetOption();
    
    public interface SetOptionRequest extends Request<SetOptionRequest, SetOptionResponse> {
        /**
         * Indicates if the action should be performed asynchronously.
         */
        SetOptionRequest async(Boolean async);
        SetOptionRequest option(Option option);
        SetOptionRequest option(OptionBuilder option);
    }
    
    public interface SetOptionResponse extends Response {
    }
    
    SetOptionRequest setOption();
    
    public interface StartRequest extends Request<StartRequest, StartResponse> {
        /**
         * Indicates if the action should be performed asynchronously.
         */
        StartRequest async(Boolean async);
        StartRequest force(Boolean force);
    }
    
    public interface StartResponse extends Response {
    }
    
    StartRequest start();
    
    public interface StartProfileRequest extends Request<StartProfileRequest, StartProfileResponse> {
        /**
         * Indicates if the action should be performed asynchronously.
         */
        StartProfileRequest async(Boolean async);
    }
    
    public interface StartProfileResponse extends Response {
    }
    
    StartProfileRequest startProfile();
    
    public interface StopRequest extends Request<StopRequest, StopResponse> {
        /**
         * Indicates if the action should be performed asynchronously.
         */
        StopRequest async(Boolean async);
        StopRequest force(Boolean force);
    }
    
    public interface StopResponse extends Response {
    }
    
    StopRequest stop();
    
    public interface StopProfileRequest extends Request<StopProfileRequest, StopProfileResponse> {
        /**
         * Indicates if the action should be performed asynchronously.
         */
        StopProfileRequest async(Boolean async);
    }
    
    public interface StopProfileResponse extends Response {
    }
    
    StopProfileRequest stopProfile();
    
    public interface StopRebalanceRequest extends Request<StopRebalanceRequest, StopRebalanceResponse> {
        /**
         * Indicates if the action should be performed asynchronously.
         */
        StopRebalanceRequest async(Boolean async);
    }
    
    public interface StopRebalanceResponse extends Response {
    }
    
    StopRebalanceRequest stopRebalance();
    
    GlusterBricksService glusterBricksService();
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

