/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.lang.String;
import java.util.Date;
import java.util.List;

public interface Vm extends VmBase {
    String fqdn();
    
    boolean fqdnPresent();
    
    GuestOperatingSystem guestOperatingSystem();
    
    boolean guestOperatingSystemPresent();
    
    TimeZone guestTimeZone();
    
    boolean guestTimeZonePresent();
    
    boolean nextRunConfigurationExists();
    
    boolean nextRunConfigurationExistsPresent();
    
    NumaTuneMode numaTuneMode();
    
    boolean numaTuneModePresent();
    
    List<Payload> payloads();
    
    boolean payloadsPresent();
    
    VmPlacementPolicy placementPolicy();
    
    boolean placementPolicyPresent();
    
    boolean runOnce();
    
    boolean runOncePresent();
    
    Date startTime();
    
    boolean startTimePresent();
    
    VmStatus status();
    
    boolean statusPresent();
    
    String statusDetail();
    
    boolean statusDetailPresent();
    
    String stopReason();
    
    boolean stopReasonPresent();
    
    Date stopTime();
    
    boolean stopTimePresent();
    
    boolean useLatestTemplateVersion();
    
    boolean useLatestTemplateVersionPresent();
    
    List<AffinityLabel> affinityLabels();
    
    boolean affinityLabelsPresent();
    
    List<Application> applications();
    
    boolean applicationsPresent();
    
    List<Cdrom> cdroms();
    
    boolean cdromsPresent();
    
    List<DiskAttachment> diskAttachments();
    
    boolean diskAttachmentsPresent();
    
    ExternalHostProvider externalHostProvider();
    
    boolean externalHostProviderPresent();
    
    List<Floppy> floppies();
    
    boolean floppiesPresent();
    
    List<GraphicsConsole> graphicsConsoles();
    
    boolean graphicsConsolesPresent();
    
    Host host();
    
    boolean hostPresent();
    
    List<HostDevice> hostDevices();
    
    boolean hostDevicesPresent();
    
    InstanceType instanceType();
    
    boolean instanceTypePresent();
    
    List<KatelloErratum> katelloErrata();
    
    boolean katelloErrataPresent();
    
    List<Nic> nics();
    
    boolean nicsPresent();
    
    List<NumaNode> numaNodes();
    
    boolean numaNodesPresent();
    
    Template originalTemplate();
    
    boolean originalTemplatePresent();
    
    List<Permission> permissions();
    
    boolean permissionsPresent();
    
    List<ReportedDevice> reportedDevices();
    
    boolean reportedDevicesPresent();
    
    List<Session> sessions();
    
    boolean sessionsPresent();
    
    List<Snapshot> snapshots();
    
    boolean snapshotsPresent();
    
    List<Statistic> statistics();
    
    boolean statisticsPresent();
    
    List<Tag> tags();
    
    boolean tagsPresent();
    
    Template template();
    
    boolean templatePresent();
    
    VmPool vmPool();
    
    boolean vmPoolPresent();
    
    List<Watchdog> watchdogs();
    
    boolean watchdogsPresent();
    
}
