/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.LogicalUnitBuilder;
import org.ovirt.engine.sdk4.internal.containers.VolumeGroupContainer;
import org.ovirt.engine.sdk4.types.LogicalUnit;
import org.ovirt.engine.sdk4.types.VolumeGroup;

public class VolumeGroupBuilder {
    private String id;
    private List<LogicalUnit> logicalUnits;
    private String name;

    public VolumeGroupBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public VolumeGroupBuilder logicalUnits(List<LogicalUnit> newLogicalUnits) {
        if (newLogicalUnits != null) {
            if (this.logicalUnits == null) {
                this.logicalUnits = new ArrayList<LogicalUnit>(newLogicalUnits);
            } else {
                this.logicalUnits.addAll(newLogicalUnits);
            }
        }
        return this;
    }

    public VolumeGroupBuilder logicalUnits(LogicalUnit ... newLogicalUnits) {
        if (newLogicalUnits != null) {
            if (this.logicalUnits == null) {
                this.logicalUnits = new ArrayList<LogicalUnit>(newLogicalUnits.length);
            }
            Collections.addAll(this.logicalUnits, newLogicalUnits);
        }
        return this;
    }

    public VolumeGroupBuilder logicalUnits(LogicalUnitBuilder ... newLogicalUnits) {
        if (newLogicalUnits != null) {
            if (this.logicalUnits == null) {
                this.logicalUnits = new ArrayList<LogicalUnit>(newLogicalUnits.length);
            }
            for (LogicalUnitBuilder builder : newLogicalUnits) {
                this.logicalUnits.add(builder.build());
            }
        }
        return this;
    }

    public VolumeGroupBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public VolumeGroup build() {
        VolumeGroupContainer container = new VolumeGroupContainer();
        container.id(this.id);
        container.logicalUnits(this.logicalUnits);
        container.name(this.name);
        return container;
    }
}

