/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.String;
import org.ovirt.engine.sdk4.internal.containers.OperatingSystemInfoContainer;
import org.ovirt.engine.sdk4.types.Icon;
import org.ovirt.engine.sdk4.types.OperatingSystemInfo;

public class OperatingSystemInfoBuilder {
    private String comment;
    private String description;
    private String href;
    private String id;
    private Icon largeIcon;
    private String name;
    private Icon smallIcon;
    
    public OperatingSystemInfoBuilder comment(String newComment) {
        comment = newComment;
        return this;
    }
    
    
    public OperatingSystemInfoBuilder description(String newDescription) {
        description = newDescription;
        return this;
    }
    
    
    public OperatingSystemInfoBuilder href(String newHref) {
        href = newHref;
        return this;
    }
    
    
    public OperatingSystemInfoBuilder id(String newId) {
        id = newId;
        return this;
    }
    
    
    public OperatingSystemInfoBuilder largeIcon(Icon newLargeIcon) {
        largeIcon = newLargeIcon;
        return this;
    }
    
    public OperatingSystemInfoBuilder largeIcon(IconBuilder newLargeIcon) {
        if (newLargeIcon == null) {
            largeIcon = null;
        }
        else {
            largeIcon = newLargeIcon.build();
        }
        return this;
    }
    
    
    public OperatingSystemInfoBuilder name(String newName) {
        name = newName;
        return this;
    }
    
    
    public OperatingSystemInfoBuilder smallIcon(Icon newSmallIcon) {
        smallIcon = newSmallIcon;
        return this;
    }
    
    public OperatingSystemInfoBuilder smallIcon(IconBuilder newSmallIcon) {
        if (newSmallIcon == null) {
            smallIcon = null;
        }
        else {
            smallIcon = newSmallIcon.build();
        }
        return this;
    }
    
    
    public OperatingSystemInfo build() {
        OperatingSystemInfoContainer container = new OperatingSystemInfoContainer();
        container.comment(comment);
        container.description(description);
        container.href(href);
        container.id(id);
        container.largeIcon(largeIcon);
        container.name(name);
        container.smallIcon(smallIcon);
        return container;
    }
}
