/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.IpContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlIpVersionReader;
import org.ovirt.engine.sdk4.types.Ip;

public class XmlIpReader {
    public static Ip readOne(XmlReader reader) {
        if (!reader.forward()) {
            return null;
        }
        IpContainer object = new IpContainer();
        reader.next();
        block14: while (reader.forward()) {
            String name;
            switch (name = reader.getLocalName()) {
                case "address": {
                    object.address(reader.readString());
                    continue block14;
                }
                case "gateway": {
                    object.gateway(reader.readString());
                    continue block14;
                }
                case "netmask": {
                    object.netmask(reader.readString());
                    continue block14;
                }
                case "version": {
                    object.version(XmlIpVersionReader.readOne(reader));
                    continue block14;
                }
                case "link": {
                    XmlIpReader.readLink(reader, object);
                    continue block14;
                }
            }
            reader.skip();
        }
        reader.next();
        return object;
    }

    public static Iterator<Ip> iterateMany(final XmlReader reader) {
        return new Iterator<Ip>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Ip next() {
                Ip next = XmlIpReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Ip> readMany(XmlReader reader) {
        ArrayList<Ip> list = new ArrayList<Ip>();
        Iterator<Ip> iterator = XmlIpReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void readLink(XmlReader reader, IpContainer object) {
        String rel = null;
        String href = null;
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attrName = reader.getAttributeLocalName(i);
            String attrVal = reader.getAttributeValue(i);
            switch (attrName) {
                case "href": {
                    href = attrVal;
                    continue block8;
                }
                case "rel": {
                    rel = attrVal;
                    continue block8;
                }
                default: {
                    reader.skip();
                }
            }
        }
        reader.skip();
    }
}

