/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum QcowVersion {
    
    QCOW2_V2,
    QCOW2_V3;
    
    private static final Logger LOG = LoggerFactory.getLogger(QcowVersion.class);
    
    public String value() {
        return name().toLowerCase();
    }
    
    public static QcowVersion fromValue(String value) {
        try {
            return valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.error("The string '" + value + "' isn't a valid value for the 'QcowVersion' enumerated type. Valid values are: 'qcow2_v2', 'qcow2_v3'.");
            return null;
        }
    }
    
}
