/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.AffinityLabelContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlHostReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVmReader;
import org.ovirt.engine.sdk4.types.AffinityLabel;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.Vm;

public class XmlAffinityLabelReader {
    public static AffinityLabel readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        AffinityLabelContainer object = new AffinityLabelContainer();
        block26: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block26;
                }
                case "id": {
                    object.id(image);
                    continue block26;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block27: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block27;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block27;
                }
                case "hosts": {
                    object.hosts(XmlHostReader.readMany(reader));
                    continue block27;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block27;
                }
                case "read_only": {
                    object.readOnly(reader.readBoolean());
                    continue block27;
                }
                case "vms": {
                    object.vms(XmlVmReader.readMany(reader));
                    continue block27;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.next();
                    continue block27;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlAffinityLabelReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<AffinityLabel> iterateMany(final XmlReader reader) {
        return new Iterator<AffinityLabel>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public AffinityLabel next() {
                AffinityLabel next = XmlAffinityLabelReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<AffinityLabel> readMany(XmlReader reader) {
        ArrayList<AffinityLabel> list = new ArrayList<AffinityLabel>();
        Iterator<AffinityLabel> iterator = XmlAffinityLabelReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(AffinityLabelContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "hosts": {
                    ArrayListWithHref<Host> list = new ArrayListWithHref<Host>(object.hosts());
                    list.href(href);
                    object.hosts(list);
                    break;
                }
                case "vms": {
                    ArrayListWithHref<Vm> list = new ArrayListWithHref<Vm>(object.vms());
                    list.href(href);
                    object.vms(list);
                    break;
                }
            }
        }
    }
}

