/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.AuthorizedKeyContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlUserReader;
import org.ovirt.engine.sdk4.types.AuthorizedKey;

public class XmlAuthorizedKeyReader {
    public static AuthorizedKey readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        AuthorizedKeyContainer object = new AuthorizedKeyContainer();
        block24: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block24;
                }
                case "id": {
                    object.id(image);
                    continue block24;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block25: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block25;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block25;
                }
                case "key": {
                    object.key(reader.readString());
                    continue block25;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block25;
                }
                case "user": {
                    object.user(XmlUserReader.readOne(reader));
                    continue block25;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.next();
                    continue block25;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlAuthorizedKeyReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<AuthorizedKey> iterateMany(final XmlReader reader) {
        return new Iterator<AuthorizedKey>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public AuthorizedKey next() {
                AuthorizedKey next = XmlAuthorizedKeyReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<AuthorizedKey> readMany(XmlReader reader) {
        ArrayList<AuthorizedKey> list = new ArrayList<AuthorizedKey>();
        Iterator<AuthorizedKey> iterator = XmlAuthorizedKeyReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(AuthorizedKeyContainer object, String[] link) {
    }
}

